/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

public class TransportSockProxyConfiguration {
    private final String proxyHost;
    private int proxyPort;
    private String username;
    private String passwd;

    public TransportSockProxyConfiguration(String address) {
        this.proxyHost = address;
        this.proxyPort = 1080;
        this.username = null;
        this.passwd = null;
    }

    public TransportSockProxyConfiguration withUsernamePassword(String user, String password) {
        this.username = user;
        this.passwd = password;
        return this;
    }

    public TransportSockProxyConfiguration withPort(int port) {
        this.proxyPort = port;
        return this;
    }

    public String getHost() {
        return this.proxyHost;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String toString() {
        if (this.username != null) {
            return "via SOCKS5 proxy(" + this.username + "@" + this.proxyHost + "/" + this.proxyPort + ")";
        }
        return "via SOCKS5 proxy(" + this.proxyHost + "/" + this.proxyPort + ")";
    }
}

