/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolEnum;
import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.LongAdder;

public abstract class JCSMPStats {
    private final String title;
    private JCSMPSession session;
    private long lastStatsReset;
    private final StatStrategy statSupport;
    private static boolean _disableStats = false;

    @Deprecated
    public JCSMPStats(String title) {
        this.title = title;
        this.session = null;
        LinkedList<StatType> v = new LinkedList<StatType>();
        Enumeration<StatType> types = StatType.elements();
        while (types.hasMoreElements()) {
            v.add(types.nextElement());
        }
        this.statSupport = new StatStrategyAtomicV3(v.size());
        this.resetStats();
    }

    public JCSMPStats(String title, JCSMPSession session) {
        this.title = title;
        this.session = session;
        LinkedList<StatType> v = new LinkedList<StatType>();
        Enumeration<StatType> types = StatType.elements();
        while (types.hasMoreElements()) {
            v.add(types.nextElement());
        }
        this.statSupport = new StatStrategyAtomicV3(v.size());
        this.resetStats();
    }

    public String getTitle() {
        return this.title;
    }

    public long getLastStatsReset() {
        return this.lastStatsReset;
    }

    public synchronized void resetStats() {
        this.statSupport.initStatsFromEnumeration(StatType.elements());
        this.lastStatsReset = System.currentTimeMillis();
    }

    private boolean isSocketLevelStats(StatType t) {
        return t.equals(StatType.TOTAL_SOCKET_BYTES_RECVED) || t.equals(StatType.TOTAL_SOCKET_BYTES_SENT) || t.equals(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED) || t.equals(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT) || t.equals(StatType.TOTAL_SOCKET_SSL_BYTES_RECVED) || t.equals(StatType.TOTAL_SOCKET_SSL_BYTES_SENT);
    }

    public long getStat(StatType t) {
        if (this.isSocketLevelStats(t) && this.session != null && this.session instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.session).getSocketLevelStat(t);
        }
        return this.statSupport.getStat(t);
    }

    public void incStat(StatType t) {
        if (_disableStats) {
            return;
        }
        this.statSupport.incStat(t);
    }

    public void incStat(StatType t, long v) {
        if (_disableStats) {
            return;
        }
        this.statSupport.incStat(t, v);
    }

    protected static final void checkStatFound(Object s) {
        if (s == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPStats.invalidStat"));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.title);
        int MINLEN = 44;
        Enumeration<StatType> e = StatType.elements();
        sb.append("\n");
        while (e.hasMoreElements()) {
            StatType t = e.nextElement();
            sb.append(StringUtil.padLeft(t.getLabel(), 44));
            sb.append(": ");
            sb.append(this.getStat(t));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isDisableStats() {
        return _disableStats;
    }

    static {
        try {
            if (System.getenv("JCSMP_DISABLE_STATS") != null) {
                _disableStats = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private final class StatStrategyNonAtomic
    extends StatStrategy {
        private long[] statTable;

        private StatStrategyNonAtomic() {
        }

        @Override
        final long getStat(StatType stat) {
            int idx = stat.getId();
            return this.statTable[idx];
        }

        @Override
        final void incStat(StatType stat) {
            int idx;
            int n = idx = stat.getId();
            this.statTable[n] = this.statTable[n] + 1L;
        }

        @Override
        final void incStat(StatType stat, long v) {
            int idx;
            int n = idx = stat.getId();
            this.statTable[n] = this.statTable[n] + v;
        }

        @Override
        final void initStatsFromEnumeration(Enumeration<StatType> types) {
            Vector<SolEnum> v = new Vector<SolEnum>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            if (this.statTable == null) {
                this.statTable = new long[v.size()];
            }
            for (SolEnum t : v) {
                this.statTable[t.getId()] = 0L;
            }
        }
    }

    private class StatStrategyAtomicV3
    extends StatStrategy {
        private final AtomicReferenceArray<LongAdder> statTable;

        public StatStrategyAtomicV3(int stateTableSize) {
            this.statTable = new AtomicReferenceArray(stateTableSize);
        }

        @Override
        long getStat(StatType stat) {
            LongAdder s = this.statTable.get(stat.getId());
            JCSMPStats.checkStatFound(s);
            return s.longValue();
        }

        @Override
        void incStat(StatType stat) {
            LongAdder s = this.statTable.get(stat.getId());
            JCSMPStats.checkStatFound(s);
            s.increment();
        }

        @Override
        void incStat(StatType stat, long v) {
            LongAdder s = this.statTable.get(stat.getId());
            JCSMPStats.checkStatFound(s);
            s.add(v);
        }

        @Override
        void initStatsFromEnumeration(Enumeration<StatType> types) {
            LinkedList<StatType> v = new LinkedList<StatType>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            for (SolEnum solEnum : v) {
                this.statTable.set(solEnum.getId(), new LongAdder());
            }
        }
    }

    private class StatStrategyAtomicV2
    extends StatStrategy {
        private final AtomicLongArray statTable;

        public StatStrategyAtomicV2(int stateTableSize) {
            this.statTable = new AtomicLongArray(stateTableSize);
        }

        @Override
        long getStat(StatType stat) {
            return this.statTable.get(stat.getId());
        }

        @Override
        void incStat(StatType stat) {
            this.statTable.incrementAndGet(stat.getId());
        }

        @Override
        void incStat(StatType stat, long v) {
            this.statTable.addAndGet(stat.getId(), v);
        }

        @Override
        void initStatsFromEnumeration(Enumeration<StatType> types) {
            LinkedList<StatType> v = new LinkedList<StatType>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            for (SolEnum solEnum : v) {
                this.statTable.set(solEnum.getId(), 0L);
            }
        }
    }

    private class StatStrategyAtomic
    extends StatStrategy {
        private AtomicLong[] statTable;

        private StatStrategyAtomic() {
        }

        @Override
        long getStat(StatType stat) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            return s.longValue();
        }

        @Override
        void incStat(StatType stat) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            s.incrementAndGet();
        }

        @Override
        void incStat(StatType stat, long v) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            s.addAndGet(v);
        }

        @Override
        void initStatsFromEnumeration(Enumeration<StatType> types) {
            Vector<SolEnum> v = new Vector<SolEnum>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            if (this.statTable == null) {
                this.statTable = new AtomicLong[v.size()];
            }
            for (SolEnum t : v) {
                this.statTable[t.getId()] = new AtomicLong();
            }
        }
    }

    private abstract class StatStrategy {
        private StatStrategy() {
        }

        abstract long getStat(StatType var1);

        abstract void incStat(StatType var1);

        abstract void incStat(StatType var1, long var2);

        abstract void initStatsFromEnumeration(Enumeration<StatType> var1);
    }
}

