/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.timers.impl;

import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.impl.timers.impl.JCSMPTimerImpl;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPTimerQueueImpl
implements JCSMPTimerQueue {
    PriorityQueue<JCSMPTimer> _tqueue = new PriorityQueue();
    static final Log Trace = LogFactory.getLog(JCSMPTimerQueueImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToNext(long curTime) {
        JCSMPTimer nTimer;
        PriorityQueue<JCSMPTimer> priorityQueue = this._tqueue;
        synchronized (priorityQueue) {
            nTimer = this._tqueue.peek();
        }
        if (nTimer != null) {
            return Math.max(nTimer.getTimeout() - curTime, 0L);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllTo(long targetTime) {
        LinkedList<JCSMPTimer> expTimersCpy = null;
        PriorityQueue<JCSMPTimer> priorityQueue = this._tqueue;
        synchronized (priorityQueue) {
            JCSMPTimer curTimer;
            while (this._tqueue.peek() != null && (curTimer = this._tqueue.peek()).getTimeout() <= targetTime) {
                if (expTimersCpy == null) {
                    expTimersCpy = new LinkedList<JCSMPTimer>();
                }
                expTimersCpy.add(this._tqueue.poll());
            }
        }
        if (expTimersCpy != null) {
            for (JCSMPTimer timer : expTimersCpy) {
                JCSMPTimeoutHandler h = timer.getHandler();
                if (h == null || !timer.isActive()) continue;
                ((JCSMPTimerImpl)timer).setExpired(true);
                h.handleTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimer(JCSMPTimer timer) {
        PriorityQueue<JCSMPTimer> priorityQueue = this._tqueue;
        synchronized (priorityQueue) {
            this._tqueue.remove(timer);
        }
        ((JCSMPTimerImpl)timer).setActive(false);
        ((JCSMPTimerImpl)timer).clearHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllTimers() {
        PriorityQueue<JCSMPTimer> priorityQueue = this._tqueue;
        synchronized (priorityQueue) {
            JCSMPTimer timer;
            while ((timer = this._tqueue.poll()) != null) {
                this.cancelTimer(timer);
            }
        }
    }

    @Override
    public JCSMPTimer schedule_relative(long offset, JCSMPTimeoutHandler handler, JCSMPTimer timer) {
        return this.schedule_absolute(System.currentTimeMillis() + offset, handler, timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCSMPTimer schedule_absolute(long time, JCSMPTimeoutHandler handler, JCSMPTimer timer) {
        JCSMPTimerImpl t_impl = (JCSMPTimerImpl)timer;
        t_impl.rescheduled(time, handler);
        PriorityQueue<JCSMPTimer> priorityQueue = this._tqueue;
        synchronized (priorityQueue) {
            this._tqueue.add(timer);
        }
        return timer;
    }

    @Override
    public JCSMPTimer schedule_relative(long offset, JCSMPTimeoutHandler handler) {
        long cTime = System.currentTimeMillis();
        return this.schedule_absolute(cTime + offset, handler);
    }

    @Override
    public JCSMPTimer schedule_absolute(long time, JCSMPTimeoutHandler handler) {
        JCSMPTimerImpl tObj = new JCSMPTimerImpl();
        return this.schedule_absolute(time, handler, tObj);
    }
}

