/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HostInfo {
    public static final String SMF_SCHEME = "smf";
    public static final String SMFS_SCHEME = "smfs";
    public static final String TCP_SCHEME = "tcp";
    public static final String TCPS_SCHEME = "tcps";
    public static String[] ALL_SCHEMES = new String[]{"smf", "smfs", "tcp", "tcps"};
    public static String[] ALL_NON_SECURE_SCHEMES = new String[]{"smf", "tcp"};
    public static String[] ALL_SECURE_SCHEMES = new String[]{"smfs", "tcps"};
    private String mOriginal;
    private String mScheme;
    private boolean mHasSlashes;
    private String mHost;
    private Integer mPort;

    private HostInfo(String original, String scheme, boolean hasSlashes, String host, Integer port) {
        this.mOriginal = original;
        this.mScheme = scheme;
        this.mHasSlashes = hasSlashes;
        this.mHost = host;
        this.mPort = port;
    }

    public String getOriginal() {
        return this.mOriginal;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public boolean hasSlashes() {
        return this.mHasSlashes;
    }

    public String getHost() {
        return this.mHost;
    }

    public Integer getPort() {
        return this.mPort;
    }

    public boolean isSecure() {
        if (this.mScheme != null) {
            for (int i = 0; i < ALL_SECURE_SCHEMES.length; ++i) {
                if (!ALL_SECURE_SCHEMES[i].toUpperCase().equals(this.mScheme.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScheme(String scheme) {
        return scheme != null && this.mScheme != null && scheme.toUpperCase().equals(this.mScheme.toUpperCase());
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("orig=");
        bldr.append(this.mOriginal);
        if (this.mScheme != null) {
            bldr.append(", scheme=");
            bldr.append(this.mScheme);
            bldr.append(":");
            if (this.mHasSlashes) {
                bldr.append("//");
            }
        }
        bldr.append(", host=");
        bldr.append(this.mHost);
        if (this.mPort != null) {
            bldr.append(", port=");
            bldr.append(this.mPort);
        }
        return bldr.toString();
    }

    public static List<HostInfo> toHostInfoList(String hostlist) {
        ArrayList<HostInfo> infos = new ArrayList<HostInfo>();
        String[] hostlistelems = hostlist.split(",");
        if (hostlist.endsWith(",")) {
            HostInfo.throwError("Empty Host Specified", null, hostlist);
        }
        for (int i = 0; i < hostlistelems.length; ++i) {
            String host = null;
            Integer port = null;
            String scheme = null;
            boolean hasDoubleSlashes = false;
            boolean expectScheme = hostlistelems[i].indexOf("://") != -1;
            String hostlistelem = hostlistelems[i].trim();
            if (hostlistelem.length() == 0) {
                HostInfo.throwError("Empty Host Specified", null, hostlist);
            }
            String upperhostlistelem = hostlistelem.toUpperCase();
            for (int j = 0; j < ALL_SCHEMES.length; ++j) {
                if (!upperhostlistelem.startsWith(ALL_SCHEMES[j].toUpperCase() + ":")) continue;
                scheme = ALL_SCHEMES[j];
                break;
            }
            if (expectScheme && scheme == null) {
                HostInfo.throwError("Invalid scheme \"" + hostlistelem.substring(0, hostlistelems[i].indexOf("://")) + "\"", hostlistelem, hostlist);
            }
            if (scheme != null && hostlistelem.indexOf("//") == scheme.length() + 1) {
                hasDoubleSlashes = true;
            }
            String[] hostelems = null;
            if (hostlistelem.contains("[") && hostlistelem.contains("]")) {
                String hostListStr = null;
                hostListStr = scheme == null ? hostlistelem.trim() : (hasDoubleSlashes ? hostlistelem.substring(hostlistelem.indexOf("//") + 2).trim() : hostlistelem.substring(hostlistelem.indexOf(":") + 1).trim());
                int start = hostListStr.indexOf("[");
                int end = hostListStr.indexOf("]");
                if (start != 0 || start + 1 > end) {
                    HostInfo.throwError("Bad host address", hostlistelem, hostlist);
                }
                if ((hostelems = hostListStr.substring(end).split(":")).length > 2) {
                    HostInfo.throwError("Too many colons", hostListStr, hostlist);
                } else if (hostelems.length == 2) {
                    port = Integer.parseInt(hostelems[1].trim());
                }
                host = hostListStr.substring(start + 1, end);
            } else {
                hostelems = hostlistelem.split(":");
                if (hostelems.length == 0) {
                    HostInfo.throwError("Empty Host Specified", null, hostlist);
                }
                if (hostelems.length > 3) {
                    HostInfo.throwError("Too many colons", hostlistelem, hostlist);
                }
                if (scheme == null) {
                    if (hostelems.length == 1) {
                        host = hostelems[0].trim();
                    } else if (hostelems.length == 2) {
                        host = hostelems[0].trim();
                        try {
                            port = Integer.parseInt(hostelems[1].trim());
                        }
                        catch (NumberFormatException e) {
                            HostInfo.throwError("NumberFormatException " + e.getMessage(), host, hostlist);
                        }
                    } else if (hostelems.length == 3) {
                        HostInfo.throwError("Invalid scheme", hostlistelem, hostlist);
                    }
                } else if (hostelems.length == 1) {
                    HostInfo.throwError("No host specified", hostlistelem, hostlist);
                } else {
                    host = hasDoubleSlashes ? hostelems[1].substring(2).trim() : hostelems[1].trim();
                    if (hostelems.length == 3) {
                        try {
                            port = Integer.parseInt(hostelems[2].trim());
                        }
                        catch (NumberFormatException e) {
                            HostInfo.throwError("NumberFormatException " + e.getMessage(), host, hostlist);
                        }
                    }
                }
            }
            if (host == null || host.length() == 0) {
                HostInfo.throwError("Empty Host Specified", null, hostlist);
            }
            infos.add(new HostInfo(hostlistelem, scheme, hasDoubleSlashes, host, port));
        }
        return infos;
    }

    public static String toHostListString(List<HostInfo> infos) {
        StringBuilder bldr = new StringBuilder();
        Iterator<HostInfo> it = infos.iterator();
        while (it.hasNext()) {
            if (bldr.length() > 0) {
                bldr.append(",");
            }
            bldr.append("[");
            bldr.append(it.next().toString());
            bldr.append("]");
        }
        return bldr.toString();
    }

    private static void throwError(String error, String host, String hostlist) {
        StringBuilder bldr = new StringBuilder();
        bldr.append(error);
        if (host != null) {
            bldr.append(" in host \"");
            bldr.append(host);
            bldr.append("\"");
        }
        if (hostlist.split(",").length > 1 || hostlist.endsWith(",")) {
            bldr.append(" in hostlist \"");
            bldr.append(hostlist);
            bldr.append("\"");
        }
        throw new IllegalArgumentException(bldr.toString());
    }

    private static void test(String hostlist) {
        try {
            System.out.print("testing \"" + hostlist + "\" -> ");
            System.out.println(HostInfo.toHostListString(HostInfo.toHostInfoList(hostlist)));
        }
        catch (Exception e) {
            System.out.println(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        HostInfo.test("");
        HostInfo.test("   ");
        HostInfo.test("   , 192.168.1.1");
        HostInfo.test("192.168.1.1,");
        HostInfo.test("192.168.1.1,    ");
        HostInfo.test("1.1.1.1");
        HostInfo.test(":1.1.1.1");
        HostInfo.test(":1.1.1.1:");
        HostInfo.test("1.1.1.1:");
        HostInfo.test("1.1.1.1:gagag");
        HostInfo.test("xyz:1.1.1.1");
        HostInfo.test("XyZ:1.1.1.1");
        HostInfo.test("xyz://1.1.1.1");
        HostInfo.test("xyz://1.1.1.1:");
        HostInfo.test("xyz://1.1.1.1:80");
        HostInfo.test("tcp://1.1.1.1");
        HostInfo.test("tcp:///1.1.1.1");
        HostInfo.test("tCps:///1.1.1.1");
        HostInfo.test("tCp://1.1.1.1");
        HostInfo.test("tcps://1.1.1.1");
        HostInfo.test("tCpS://1.1.1.1");
        HostInfo.test("tcp:1.1.1.1");
        HostInfo.test("tcps:1.1.1.1");
        HostInfo.test("tcp:1.1.1.1:90");
        HostInfo.test("tcp:1.1.1.1:gaga");
        HostInfo.test("tcps:1.1.1.1:90");
        HostInfo.test("tcp://1.1.1.1:90");
        HostInfo.test("tcps://1.1.1.1:90");
        HostInfo.test(":80");
        HostInfo.test("");
        HostInfo.test(":");
        HostInfo.test("::");
        HostInfo.test(":::");
        HostInfo.test("::::");
        HostInfo.test("   ");
        HostInfo.test("    tcp:   //1.1.1.1:   90");
        HostInfo.test("    tCP:   //1.1.1.1:   90");
        HostInfo.test("   tcps:   //1.1.1.1:   90");
        HostInfo.test("tcp:tcp:");
        HostInfo.test("tcp:");
        HostInfo.test("TCP:");
        HostInfo.test(TCP_SCHEME);
        HostInfo.test("tcps://");
        HostInfo.test("tcps://tcps://");
        HostInfo.test("tcpS://");
        HostInfo.test(",tcps://1.1.1.1:90");
        HostInfo.test(",tCps://1.1.1.1:90");
        HostInfo.test("://");
        HostInfo.test("://://");
    }
}

