/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.SDTUnknownType;

public class UnsupportedTLV
implements SDTUnknownType {
    private Reason mReason;
    private byte mTag;
    private String mMessage;
    private ByteArray mByteArray;

    public UnsupportedTLV(Reason reason, byte tag, String message, ByteArray byteArray) {
        this.mReason = reason;
        this.mTag = tag;
        this.mMessage = message;
        this.mByteArray = byteArray;
    }

    public Reason getReason() {
        return this.mReason;
    }

    public int getTag() {
        return this.mTag;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public ByteArray getByteArray() {
        return this.mByteArray;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsupportedTLV) {
            UnsupportedTLV other = (UnsupportedTLV)obj;
            return this.mByteArray.equals(other.mByteArray);
        }
        return false;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        if (this.mReason.equals((Object)Reason.UnsupportedTag)) {
            bldr.append("Unsupported Tag (");
        } else if (this.mReason.equals((Object)Reason.UnsupportedLength)) {
            bldr.append("Unsupported Length (");
        } else if (this.mReason.equals((Object)Reason.UnsupportedFormat)) {
            bldr.append("Unsupported Format (");
        } else {
            return "";
        }
        int length = this.mByteArray.getLength();
        bldr.append("tag=");
        bldr.append(this.mTag);
        bldr.append(",length=");
        bldr.append(length);
        if (this.mMessage == null) {
            bldr.append(")");
        } else {
            bldr.append(") - ");
            bldr.append(this.mMessage);
        }
        if (length <= 100) {
            byte[] data = this.mByteArray.getBuffer();
            bldr.append(", Data=[");
            for (int i = 0; i < length; ++i) {
                bldr.append(data[i]);
                if (i >= length - 1) continue;
                bldr.append(",");
            }
            bldr.append("]");
        }
        return bldr.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        UnsupportedTag,
        UnsupportedLength,
        UnsupportedFormat;

    }
}

