/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLoginFailureException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Pair;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.InternalCapabilityType;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.csmp.CSMPMessageFactory;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategy;
import com.solacesystems.jcsmp.protocol.impl.RouterCapabilityParser;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.SubscriberMessageReader;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.PubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.BinaryMetadataEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelOpStrategyPubdata
extends ChannelOpStrategy {
    private static final Log Trace = LogFactory.getLog(ChannelOpStrategyPubdata.class);

    public ChannelOpStrategyPubdata(TcpClientChannel channel) {
        super(channel);
    }

    @Override
    public void performOpen(boolean isReconn) throws JCSMPException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"About to open TcpPublisherChannel");
        }
        this.doPubCtrl(null, 0);
        SocketChannel sc = this.c_refs.smfClient.getSocket().getChannel();
        try {
            sc.configureBlocking(false);
        }
        catch (IOException e) {
            throw new JCSMPTransportException("Transport error.", e);
        }
        SubscriberMessageReader messageReader = new SubscriberMessageReader(sc, this.channel, false, this.c_refs.sessionStats);
        this.c_refs.smfClient.setSubscriberMessageReader(messageReader);
        this.channel.start();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Done open publisher data channel");
        }
    }

    private void doPubCtrl(String udpLocalIp, int udpPort) throws JCSMPException {
        WireMessage response;
        String clientUsername = this.c_refs.sessionProperties.getStringProperty("username");
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(8).setTtl(1);
        PubCtrlHeaderBean pubCtrlHeader = CSMPMessageFactory.onlyInstance().buildPublisherControlMessageBean(udpPort, udpLocalIp, this.channel.isExplicitAckEnabled());
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, pubCtrlHeader);
        try {
            response = this.channel.executePostOnce(msgReq, true);
        }
        catch (JCSMPErrorResponseException err) {
            throw new JCSMPLoginFailureException(1, clientUsername, err.getResponseCode(), err.getResponsePhrase());
        }
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() == 8) {
            pubCtrlHeader = (PubCtrlHeaderBean)response.getHeaderBean();
            if (pubCtrlHeader.getProtocolVersion() != 2) {
                throw new VersionNotSupportException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.badVersion"));
            }
        } else {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.badMessageExpectedPubCtrlResponse"));
        }
        if (!(response.getHeaderBean() instanceof PubCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedPubCtrlResponseBlockNotFound"));
        }
        PubCtrlHeaderBean pub_ctrl_hdr = (PubCtrlHeaderBean)response.getHeaderBean();
        AbstractTLVParameter param_cap = pub_ctrl_hdr.findFirstParameter(4);
        AbstractTLVParameter param_sversion = pub_ctrl_hdr.findFirstParameter(5);
        AbstractTLVParameter param_sdate = pub_ctrl_hdr.findFirstParameter(6);
        AbstractTLVParameter param_platform = pub_ctrl_hdr.findFirstParameter(7);
        Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>> caps_pair = RouterCapabilityParser.parseCapabilitiesFromHeader(param_cap, null, param_sversion, param_sdate, param_platform, null, false);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.CAP, caps_pair.getFirst(), false);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.INTERNAL_CAP, caps_pair.getSecond(), false);
        AbstractTLVParameter param_csmpvrid = pub_ctrl_hdr.findFirstParameter(8);
        if (param_csmpvrid != null) {
            String csmpvrid = TlvCoderUtil.nullTermAsciiToString(param_csmpvrid.value);
            String existVridName = this.c_refs.sessionProperties.getStringProperty("VIRTUAL_ROUTER_NAME");
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", csmpvrid);
            this.checkVridChangeOnLogin(existVridName, csmpvrid);
        } else {
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", "501ACE00");
        }
    }

    @Override
    public void updateClientDescription(String clientDesc) throws JCSMPException {
    }

    @Override
    public void updateClientName(String uniqueName, String defaultName) throws JCSMPException {
    }

    @Override
    public void updateAuthenticationParameters(AuthenticationSchemeParameters newAuthParams) throws JCSMPException {
    }

    @Override
    public void buildSendMsgHeader(JCSMPXMLMessage message, Destination destination, long msgId_64bit, long flowId, long publisherId, boolean newMsg) throws InvalidOperationException {
        ChannelOpStrategyPubdata.buildSMFPubMsgHeader(message, msgId_64bit, flowId, newMsg);
    }

    public static void buildSMFPubMsgHeader(JCSMPXMLMessage message, long msgId_64bit, long flowId, boolean newMsg) {
        byte[] userdata;
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        SMFPubMsgHeaderBean smfHeader = message.getEncPubMsgHeader();
        smfHeader.reset();
        smfHeader.setUserCosValue(message.getCos().value());
        smfHeader.setDmqEligible(message.isDMQEligible() ? 1 : 0);
        smfHeader.setElidingEligible(message.isElidingEligible() ? 1 : 0);
        if (JCSMPUtils.isAdMessage(message)) {
            smfHeader.setAdf(1);
            if (message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                pfac.addDeliveryMode(smfHeader, 1);
            } else {
                pfac.addDeliveryMode(smfHeader, 0);
            }
            pfac.addAssuredMsgId(smfHeader, msgId_64bit);
            pfac.addAssuredPrevMsgId(smfHeader, message.getPrevMessageId());
            if (!newMsg) {
                pfac.addAssuredRedeliveredFlag(smfHeader);
            }
            if (flowId != -1L) {
                pfac.addAssuredFlowId(smfHeader, flowId);
            }
        }
        if (message.getPriority() != -1) {
            pfac.addMessagePriorty(smfHeader, message.getPriority());
        }
        if (message.getTimeToLive() > 0L) {
            pfac.addAssuredTtl(smfHeader, message.getTimeToLive());
        }
        if ((userdata = message.getUserData()) != null) {
            pfac.addUserdata(smfHeader, userdata);
        }
        if (message.getTopicNameOffset() >= 0 && message.getTopicNameLength() >= 0) {
            pfac.addTopicNameOffset(smfHeader, message.getTopicNameOffset(), message.getTopicNameLength());
        }
        if (message.getQueueNameOffset() >= 0 && message.getQueueNameLength() >= 0) {
            pfac.addQueueNameOffset(smfHeader, message.getQueueNameOffset(), message.getQueueNameLength());
        }
        int messageTotalLength = message.getContentLength();
        if (message.hasMetadata() || message.hasContent() || message.hasAttachment() || message.hasBinaryMetadataAny()) {
            int metadataLength = message.getMetadataContentLength();
            messageTotalLength += metadataLength;
            int attLength = message.getAttachmentContentLength();
            messageTotalLength += attLength;
            int binMetaEncodedLength = 0;
            if (message.hasBinaryMetadataAny()) {
                binMetaEncodedLength = BinaryMetadataEncoder.getBinaryMetaEncodedLength(message.getBinaryMetadataCB());
            }
            messageTotalLength += binMetaEncodedLength;
            int metadataLen = metadataLength > 0 ? metadataLength : -1;
            int contentLen = message.getContentLength() > 0 ? message.getContentLength() : -1;
            int attLen = message.hasAttachment() ? message.getAttachmentContentLength() : -1;
            int binMetaLen = binMetaEncodedLength > 0 ? binMetaEncodedLength : -1;
            pfac.addMessageContentSummary(smfHeader, metadataLen, contentLen, attLen, binMetaLen);
        }
        smfHeader.setMsgLen(messageTotalLength);
    }

    @Override
    public void establishP2pSub() throws JCSMPException {
    }
}

