/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.impl.AbstractSMFReadHandler;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.PubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.PubSubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.AssuredCtrlHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.AssuredCtrlHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.ClientCtrlHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.ClientCtrlHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.PubSubCtrlHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.PubSubCtrlHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SmpHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SmpHeaderEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SMFWireMessageHandler
implements WireMessageHandler {
    SMFHeaderDecoder smfDecoder = new SMFHeaderDecoder();
    SMFHeaderEncoder smfEncoder = new SMFHeaderEncoder();
    PubSubCtrlHeaderDecoder ctrlDecoder = new PubSubCtrlHeaderDecoder();
    PubSubCtrlHeaderEncoder ctrlEncoder = new PubSubCtrlHeaderEncoder();
    AssuredCtrlHeaderDecoder assDecoder = new AssuredCtrlHeaderDecoder();
    AssuredCtrlHeaderEncoder assEncoder = new AssuredCtrlHeaderEncoder();
    ClientCtrlHeaderDecoder clientDecoder = new ClientCtrlHeaderDecoder();
    ClientCtrlHeaderEncoder clientEncoder = new ClientCtrlHeaderEncoder();
    SmpHeaderDecoder smpDecoder = new SmpHeaderDecoder();
    SmpHeaderEncoder smpEncoder = new SmpHeaderEncoder();
    PubCtrlHeaderBean _pubctrlHeader = new PubCtrlHeaderBean();
    SubCtrlHeaderBean _subctrlHeader = new SubCtrlHeaderBean();
    ClientCtrlHeaderBean _clientHeader = new ClientCtrlHeaderBean();
    SmpHeaderBean _smpHeader = new SmpHeaderBean();
    SMFHeaderBean _smfHeader = new SMFHeaderBean();
    ByteArrayOutputStream _baos = new ByteArrayOutputStream(4096);

    public void readMessage(ByteBuffer buf, WireMessage msg) throws IOException {
        try {
            msg.reset();
            this._smfHeader.reset();
            this.smfDecoder.decodeHeader(buf, (HeaderDescriptionBean)this._smfHeader);
            msg.setSmfHeader(this._smfHeader);
            this.readPayload(null, buf, msg);
        }
        catch (OutOfMemoryError oom) {
            throw new IOException("OutOfMemoryError parsing SMF message (message too big): " + oom.getMessage());
        }
    }

    @Override
    public void readMessage(InputStream istr, WireMessage msg) throws IOException {
        try {
            msg.reset();
            this._smfHeader.reset();
            this.smfDecoder.decodeHeader(istr, (HeaderDescriptionBean)this._smfHeader);
            msg.setSmfHeader(this._smfHeader);
            this.readPayload(istr, null, msg);
        }
        catch (OutOfMemoryError oom) {
            throw new IOException("OutOfMemoryError parsing SMF message (message too big): " + oom.getMessage());
        }
    }

    private static void copyBufData(InputStream istr, ByteBuffer inputBuf, byte[] outputBuf) throws IOException {
        if (istr != null) {
            NetworkIOUtil.readDataSafely(istr, outputBuf, 0, outputBuf.length);
        } else {
            inputBuf.get(outputBuf, 0, outputBuf.length);
        }
    }

    private void readPayload(InputStream istr, ByteBuffer inputBuf, WireMessage msg) throws IOException {
        byte[] buf = null;
        int len = 0;
        if (this._smfHeader.isUnknownProtocol()) {
            len = this._smfHeader.getMsgLen();
            buf = new byte[len];
            SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
            msg.setPayload(buf);
            return;
        }
        switch (this._smfHeader.getProtocol()) {
            case 2: 
            case 14: 
            case 20: {
                len = this._smfHeader.getMsgLen();
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 3: 
            case 13: {
                len = this._smfHeader.getMsgLen();
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 8: {
                if (this._smfHeader.getMsgLen() <= 0) break;
                this._pubctrlHeader.reset();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.ctrlDecoder.decodeHeader(istr, this._pubctrlHeader);
                msg.addHeaderBean(this._pubctrlHeader);
                break;
            }
            case 7: {
                if (this._smfHeader.getMsgLen() <= 0) break;
                this._subctrlHeader.reset();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.ctrlDecoder.decodeHeader(istr, this._subctrlHeader);
                msg.addHeaderBean(this._subctrlHeader);
                break;
            }
            case 10: 
            case 11: {
                len = this._smfHeader.getMsgLen();
                if (len <= 0) break;
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 9: 
            case 19: {
                if (this._smfHeader.getMsgLen() <= 0) break;
                AssuredCtrlHeaderBean adctrlHeader = new AssuredCtrlHeaderBean();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.assDecoder.decodeHeader(istr, adctrlHeader);
                msg.addHeaderBean(adctrlHeader);
                break;
            }
            case 12: {
                if (this._smfHeader.getMsgLen() <= 0) break;
                this._clientHeader.reset();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.clientDecoder.decodeHeader(istr, this._clientHeader);
                msg.addHeaderBean(this._clientHeader);
                break;
            }
            case 15: {
                if (this._smfHeader.getMsgLen() <= 0) break;
                this._smpHeader.reset();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.smpDecoder.decodeHeader(istr, this._smpHeader);
                msg.addHeaderBean(this._smpHeader);
            }
        }
    }

    private void writeData(OutputStream ostr, byte[] buf) throws IOException {
        ostr.write(buf);
    }

    @Override
    public synchronized void writeMessage(OutputStream ostr, WireMessage msg) throws IOException {
        SMFHeaderBean smfHeader = msg.getSmfHeader();
        this._baos.reset();
        switch (smfHeader.getProtocol()) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 14: {
                smfHeader.setMsgLen(msg.getPayload().length);
                this.smfEncoder.encodeHeader(this._baos, smfHeader);
                if (msg.getPayload().length <= 0) break;
                this.writeData(this._baos, msg.getPayload());
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                HeaderDescriptionBean ctrlHeader = msg.getHeaderBean();
                smfHeader.setMsgLen(ctrlHeader.getSmfEncodedLength());
                this.smfEncoder.encodeHeader(this._baos, smfHeader);
                if (ctrlHeader instanceof PubSubCtrlHeaderBean) {
                    this.ctrlEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                if (ctrlHeader instanceof AssuredCtrlHeaderBean) {
                    this.assEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                if (ctrlHeader instanceof ClientCtrlHeaderBean) {
                    this.clientEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                if (ctrlHeader instanceof SmpHeaderBean) {
                    this.smpEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                throw new IOException(JCSMPRB.BUNDLE.getStringSafely("SMFWireMessageHandler.encodingError"));
            }
        }
        this._baos.writeTo(ostr);
        ostr.flush();
    }
}

