/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl.test;

import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TcpClientChannelReconnectTriggerTest
implements Runnable {
    final int tpSize;
    final ExecutorService ex;
    final AtomicBoolean shutdownReq;
    final TcpClientChannel channel;
    final AtomicInteger ctr = new AtomicInteger(0);

    public TcpClientChannelReconnectTriggerTest(int threadPoolSize, TcpClientChannel channel) {
        this.tpSize = threadPoolSize;
        this.ex = Executors.newFixedThreadPool(this.tpSize);
        this.shutdownReq = new AtomicBoolean(false);
        this.channel = channel;
    }

    public void shutdown() {
        this.shutdownReq.set(true);
    }

    @Override
    public void run() {
        try {
            Thread.sleep(10000L);
            int iterations = 1;
            Random r = new Random();
            while (!this.shutdownReq.get()) {
                for (int i = 0; i < this.tpSize; ++i) {
                    Runnable killTask = new Runnable(){

                        @Override
                        public void run() {
                            int this_ctr = TcpClientChannelReconnectTriggerTest.this.ctr.incrementAndGet();
                            TcpClientChannelReconnectTriggerTest.this.channel.handleException((Exception)((Object)new JCSMPTransportException("dummy connection failure " + String.valueOf(this_ctr))));
                        }
                    };
                    this.ex.submit(killTask);
                }
                if (++iterations % 10 == 0) {
                    Thread.sleep(1000L);
                    continue;
                }
                int sleeptime = r.nextInt(500);
                Thread.sleep(sleeptime);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

