/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.InternalConnectEvent;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManagerSmf;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.SeqNum63bAllocator;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransactedSessionManager
implements Closeable {
    private final LogWrapper Trace = new LogWrapper(TransactedSessionManager.class);
    JCSMPBasicSession _session = null;
    TcpClientChannel subChannel = null;
    TransactedSessionManagerSmf transactionSmf = null;
    Set<TransactedSessionImpl> managedTransactions = null;
    Map<Long, TransactedSessionImpl> activeTransactions = null;
    ContextImpl context;
    private final AtomicBoolean _checkUnboundFlows = new AtomicBoolean(true);
    private SeqNumAllocator sessionTagAlloc = null;
    private boolean allocRollover;
    private boolean reconnectAborted;
    private JCSMPException abortException;

    public TransactedSessionManager(JCSMPBasicSession session, ContextImpl context) {
        this._session = session;
        this.managedTransactions = new HashSet<TransactedSessionImpl>();
        this.activeTransactions = new HashMap<Long, TransactedSessionImpl>();
        this.transactionSmf = new TransactedSessionManagerSmf(this);
        this.context = context;
        this.sessionTagAlloc = new SeqNum63bAllocator("sessionCorrelationTagSeqAllocator");
        this.sessionTagAlloc.getNext63b();
        this.allocRollover = false;
        this.reconnectAborted = false;
        this.abortException = null;
        this.Trace.setContextInfo(this.getLogContextInfo());
    }

    public String getLogContextInfo() {
        return this._session.getLogContextInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getNextSessionTag() {
        int tag = this.sessionTagAlloc.getNext24b();
        if (tag == 0) {
            this.allocRollover = true;
            tag = this.sessionTagAlloc.getNext24b();
        }
        if (this.allocRollover) {
            Set<TransactedSessionImpl> managedCpy;
            Set<TransactedSessionImpl> set = this.managedTransactions;
            synchronized (set) {
                managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
            }
            boolean used = false;
            while (true) {
                for (TransactedSessionImpl ts : managedCpy) {
                    if (!(ts instanceof AdCtrlV4TransactedSessionImpl) || ((AdCtrlV4TransactedSessionImpl)ts).getSessionTag() != (long)tag) continue;
                    used = true;
                    break;
                }
                if (!used) {
                    return tag;
                }
                ++tag;
                used = false;
            }
        }
        return tag;
    }

    public String getNetworkInfoString() {
        String networkInfo = "";
        if (this.subChannel != null) {
            networkInfo = this.subChannel.getNetworkInfoString();
        }
        return networkInfo;
    }

    public void setSubChannel(TcpClientChannel channel) {
        this.subChannel = channel;
        if (channel != null) {
            channel.setTransactedSessionMgr(this);
        }
    }

    public TcpClientChannel getSubChannel() {
        return this.subChannel;
    }

    public JCSMPBasicSession getSession() {
        return this._session;
    }

    public synchronized TransactedSessionImpl createTransactedSession() throws JCSMPException {
        AdCtrlV4TransactedSessionImpl ts = new AdCtrlV4TransactedSessionImpl(this, this.getSubChannel().getChannelProperties());
        this._session.waitUntilSessionReconnectDone("createTransactedSession");
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("createTransactedSession: downgrade=" + ts.isDowngradeEnabled());
        }
        if (ts.isDowngradeEnabled()) {
            this.transactionSmf.doOpenTxSession(ts, true);
        } else {
            this.transactionSmf.doOpenAdCtrlV4TxSession(ts, true);
        }
        return ts;
    }

    public void closeTransactedSession(TransactedSessionImpl ts, boolean graceful) {
        this.transactionSmf.doCloseTransactedSession(ts, graceful);
    }

    public void closeAdCtrlV4TransactedSession(AdCtrlV4TransactedSessionImpl ts) {
        this.transactionSmf.doCloseAdCtrlV4TransactedSession(ts);
    }

    public void handleAsyncAssuredCtrlMessage(WireMessage wmsg) {
        try {
            this.transactionSmf.handleAsyncAssuredCtrlMessage(wmsg);
        }
        catch (JCSMPException e) {
            this.Trace.info("Error handling async assuredctrl message, dropped.", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchAssuredCtrlMessage(AssuredCtrlEnums.TransactionCtrlMessageType mtype, long transactedSessionId, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
        TransactedSessionImpl dispatch_target;
        Map<Long, TransactedSessionImpl> map = this.activeTransactions;
        synchronized (map) {
            dispatch_target = this.activeTransactions.get(transactedSessionId);
        }
        if (dispatch_target != null) {
            if (dispatch_target instanceof AdCtrlV4TransactedSessionImpl) {
                if (((AdCtrlV4TransactedSessionImpl)dispatch_target).isDowngradeEnabled()) {
                    dispatch_target.handleControlMessage(mtype, adctrl, err_resp);
                } else {
                    ((AdCtrlV4TransactedSessionImpl)dispatch_target).handleAdCtrlMessage(mtype, adctrl, correlationId, respCode, err_resp);
                }
            } else {
                dispatch_target.handleControlMessage(mtype, adctrl, err_resp);
            }
        } else {
            switch (mtype) {
                case CLOSE_TRANSACTED_SESSION: {
                    break;
                }
                default: {
                    this.Trace.info("Ignored assuredctrl message, no associated TransactedSession. " + (Object)((Object)mtype));
                }
            }
        }
    }

    public void sendCommitRequest(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendCommit(transactedSessionId, tid, pubnotify, suback, dropOnAppThread, connIdx);
    }

    public void sendAdCtrlV4CommitRequest(long transactedSessionId, long correlationId, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendAdCtrlV4Commit(transactedSessionId, correlationId, pubnotify, suback, dropOnAppThread, connIdx);
    }

    public void sendRollbackRequest(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendRollback(transactedSessionId, tid, pubnotify, suback, dropOnAppThread, connIdx);
    }

    public void sendAdCtrlV4RollbackRequest(long transactedSessionId, long correlationId, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendAdCtrlV4Rollback(transactedSessionId, correlationId, dropOnAppThread, connIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManagedTransactedSession(TransactedSessionImpl ts) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            Map<Long, TransactedSessionImpl> map = this.activeTransactions;
            synchronized (map) {
                this.managedTransactions.add(ts);
                this.activeTransactions.put(ts.getTransactedSessionId(), ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManagedTransactedSession(TransactedSessionImpl ts) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            Map<Long, TransactedSessionImpl> map = this.activeTransactions;
            synchronized (map) {
                this.managedTransactions.remove(ts);
                TransactedSessionManager.removeEntries(this.activeTransactions, ts);
            }
        }
    }

    private static void removeEntries(Map<Long, TransactedSessionImpl> map, TransactedSessionImpl e) {
        Set<Map.Entry<Long, TransactedSessionImpl>> entries = map.entrySet();
        Iterator<Map.Entry<Long, TransactedSessionImpl>> x = entries.iterator();
        while (x.hasNext()) {
            Map.Entry<Long, TransactedSessionImpl> next = x.next();
            if (!next.getValue().equals(e)) continue;
            x.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchTransactionsList(List<TransactedSessionImpl> to_close) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            to_close.addAll(this.managedTransactions);
        }
    }

    public void dispatchChannelException(JCSMPException ex, List<TransactedSessionImpl> to_close) {
        for (TransactedSessionImpl s : to_close) {
            s.handleUnrecoverableException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<TransactedSessionImpl> to_close = new LinkedList<TransactedSessionImpl>();
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            to_close.addAll(this.managedTransactions);
        }
        for (TransactedSessionImpl s : to_close) {
            s.close();
        }
    }

    private static <E> Set<E> copySet(Collection<E> s) {
        HashSet<E> newset = new HashSet<E>();
        newset.addAll(s);
        return newset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownName() {
        Set<TransactedSessionImpl> managedCpy;
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
        }
        for (TransactedSessionImpl ts : managedCpy) {
            ts.notifyUnknownName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVridChange() {
        Set<TransactedSessionImpl> managedCpy;
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
        }
        for (TransactedSessionImpl ts : managedCpy) {
            ts.notifyVridChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAdCtrlVersionChange(boolean downgrade) {
        Set<TransactedSessionImpl> managedCpy;
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
        }
        for (TransactedSessionImpl ts : managedCpy) {
            ts.notifyAdCtrlVersionChange(downgrade);
        }
    }

    public boolean reconnectInProgress() {
        return this._session.isReconnectInProgress();
    }

    public boolean checkUnboundFlows() {
        return this._checkUnboundFlows.get();
    }

    public void checkUnboundFlows(boolean check) {
        this.Trace.debug("Turn on (true) /off (false) unbound flow checking: " + check);
        this._checkUnboundFlows.getAndSet(check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectEvent(InternalConnectEvent ev) throws JCSMPException {
        this.Trace.debug(String.format("Got connect event: %s", ev));
        switch (ev.type) {
            case PRE_RECONNECT: {
                Set<TransactedSessionImpl> managedCpy;
                Set<TransactedSessionImpl> set = this.managedTransactions;
                synchronized (set) {
                    managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
                }
                this.checkUnboundFlows(false);
                for (TransactedSessionImpl ts : managedCpy) {
                    ts.responseTimerSetter.stopTimer();
                    ts.notifyPreReconnect();
                }
                break;
            }
            case POST_RECONNECT: {
                Set<TransactedSessionImpl> sessionsToRebind;
                Set<TransactedSessionImpl> ts = this.managedTransactions;
                synchronized (ts) {
                    Map<Long, TransactedSessionImpl> map = this.activeTransactions;
                    synchronized (map) {
                        this.activeTransactions.clear();
                        sessionsToRebind = TransactedSessionManager.copySet(this.managedTransactions);
                    }
                }
                for (TransactedSessionImpl ts2 : sessionsToRebind) {
                    if (ts2 instanceof AdCtrlV4TransactedSessionImpl) {
                        if (((AdCtrlV4TransactedSessionImpl)ts2).isDowngradeEnabled()) {
                            this.transactionSmf.doOpenTxSession(ts2, false);
                        } else if (ts2.getName() == null) {
                            this.transactionSmf.doOpenAdCtrlV4TxSession((AdCtrlV4TransactedSessionImpl)ts2, false);
                        } else {
                            this.transactionSmf.doResumeAdCtrlV4TxSession((AdCtrlV4TransactedSessionImpl)ts2, ts2.isUpgradeInProgress());
                        }
                    } else {
                        this.transactionSmf.doOpenTxSession(ts2, false);
                    }
                    this.addManagedTransactedSession(ts2);
                }
                break;
            }
            case FLOW_REBIND_FINISHED: {
                Set<TransactedSessionImpl> activeCpy;
                Map<Long, TransactedSessionImpl> ts2 = this.activeTransactions;
                synchronized (ts2) {
                    activeCpy = TransactedSessionManager.copySet(this.activeTransactions.values());
                }
                this.checkUnboundFlows(true);
                for (TransactedSessionImpl ts : activeCpy) {
                    ts.notifyFlowRebindFinished();
                }
                break;
            }
            case ABORT_RECONNECT: {
                Set<TransactedSessionImpl> sessions;
                this.reconnectAborted = true;
                this.abortException = ev.getException();
                Set<TransactedSessionImpl> set = this.managedTransactions;
                synchronized (set) {
                    sessions = TransactedSessionManager.copySet(this.managedTransactions);
                }
                for (TransactedSessionImpl ts : sessions) {
                    ts.handlePostAbortedReconnect(ev.getException());
                }
                break;
            }
        }
    }

    public boolean isReconnetAborted() {
        return this.reconnectAborted;
    }

    public JCSMPException getReconnectAbortException() {
        if (this.abortException == null) {
            this.abortException = new JCSMPTransportException("session reconnect aborted");
        }
        return this.abortException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            sb.append(String.format("%s transacted sessions:%n", this.managedTransactions.size()));
            for (TransactedSessionImpl ts : this.managedTransactions) {
                sb.append("    ").append(ts.toString()).append("%n");
            }
        }
        return sb.toString();
    }
}

