/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.requestreply;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPRequestTimeoutException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.Request;
import com.solacesystems.jcsmp.impl.RequestListener;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericRequestTask
implements RequestListener {
    private static final Log Trace = LogFactory.getLog(GenericRequestTask.class);
    private final ArrayBlockingQueue<Object> _syncQ = new ArrayBlockingQueue(1);
    private final Request _request;
    private final XMLMessage _msg;
    private final JCSMPSession _session;
    private final boolean _isBlocking;

    public GenericRequestTask(JCSMPSession session, XMLMessage outgoingMsg, XMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Destination destination, long timeout) {
        this._session = session;
        this._msg = outgoingMsg;
        this._isBlocking = timeout > 0L;
        this._request = new Request(this._session, producer, consumer.getLiveMessageController(), outgoingMsg, destination, timeout, this);
    }

    private void addCorrelationId(XMLMessage msg, long id) {
        if (msg.getCorrelationId() != null) {
            return;
        }
        msg.setCorrelationId(String.format("#REQ%s", id));
    }

    private void addReplyTo(XMLMessage msg) {
        if (msg.getReplyTo() != null) {
            return;
        }
        Topic replyToTopic = (Topic)this._session.getProperty("p2pinbox_in_use");
        msg.setReplyTo(replyToTopic);
    }

    public void send() throws JCSMPException {
        if (this._isBlocking) {
            this.addCorrelationId(this._msg, this._request.getId());
        }
        this.addReplyTo(this._msg);
        this._request.send();
    }

    public BytesXMLMessage waitForResponse() throws JCSMPException {
        Object ret_obj = null;
        try {
            ret_obj = this._syncQ.take();
        }
        catch (InterruptedException ex) {
            ret_obj = new JCSMPInterruptedException("waitForResponse interrupted", ex);
        }
        if (ret_obj instanceof JCSMPException) {
            throw (JCSMPException)((Object)ret_obj);
        }
        return (BytesXMLMessage)ret_obj;
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onException(JCSMPException exception) {
        Trace.debug((Object)("RequestTask.onException: " + (Object)((Object)exception)));
        if (!this._syncQ.offer((Object)exception)) {
            Trace.debug((Object)"offer failed");
        }
    }

    @Override
    public void onResponse(JCSMPXMLMessage message) {
        Trace.debug((Object)("RequestTask.onResponse: " + message));
        if (!this._syncQ.offer(FlowHandleImpl.createStructuredType(message))) {
            Trace.debug((Object)"offer failed");
        }
    }

    @Override
    public void onTimeout() {
        JCSMPRequestTimeoutException timeoutEx = new JCSMPRequestTimeoutException("Timeout occurred performing request");
        this.onException(timeoutEx);
    }
}

