/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.DefaultFlowQueueHookImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPXMLMessageConsumer
implements XMLMessageConsumer {
    private static final Log Trace = LogFactory.getLog(JCSMPXMLMessageConsumer.class);
    private FlowHandleImpl flowHandle;

    public JCSMPXMLMessageConsumer(FlowHandleImpl classicFlowHandle, JCSMPBasicSession session) {
        this.flowHandle = classicFlowHandle;
        this.flowHandle.setSubQueueHooks(new DefaultFlowQueueHookImpl(this.flowHandle));
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Created XMLMessageConsumer");
        }
    }

    public FlowHandleImpl getFlowHandle() {
        return this.flowHandle;
    }

    public LiveMessageController getLiveMessageController() {
        return this.flowHandle.getLiveMessageController();
    }

    @Override
    public synchronized void start() throws JCSMPException {
        this.flowHandle.start();
    }

    @Override
    public synchronized void startSync() throws JCSMPException {
        this.flowHandle.startSync();
    }

    @Override
    public synchronized void stop() {
        this.flowHandle.stop();
    }

    @Override
    public synchronized void stopSync() throws JCSMPInterruptedException {
        this.flowHandle.stopSync();
    }

    @Override
    public synchronized void close() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Consumer about to close");
        }
        this.flowHandle.close();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Closed XMLMessageConsumer");
        }
    }

    @Override
    public synchronized void closeSync() throws JCSMPException {
        this.flowHandle.closeSync();
    }

    @Override
    public synchronized void closeSync(boolean linger) throws JCSMPException {
        this.flowHandle.closeSync(linger);
    }

    @Override
    public XMLMessageListener getMessageListener() {
        return this.flowHandle.getMessageListener();
    }

    @Override
    public void setMessageListener(XMLMessageListener listener) {
        this.flowHandle.setMessageListener(listener);
    }

    @Override
    public BytesXMLMessage receive() throws JCSMPException {
        return this.flowHandle.receive();
    }

    @Override
    public BytesXMLMessage receiveNoWait() throws JCSMPException {
        return this.flowHandle.receiveNoWait();
    }

    @Override
    public BytesXMLMessage receive(int timeoutInMillis) throws JCSMPException {
        return this.flowHandle.receive(timeoutInMillis);
    }

    @Override
    public boolean stopSyncStart() {
        return this.flowHandle.stopSyncStart();
    }

    @Override
    public void stopSyncWait() throws JCSMPInterruptedException {
        this.flowHandle.stopSyncWait();
    }
}

