/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import com.solacesystems.jcsmp.impl.compression.SolZlibCallResult;
import com.solacesystems.jcsmp.impl.compression.SolZlibDeflatePipe;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.IOReactor;
import com.solacesystems.jcsmp.protocol.nio.impl.NioSmfUtil;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZSmfClient
extends SimpleSmfClient {
    private static final Log Trace = LogFactory.getLog(ZSmfClient.class);
    public SolZlibDeflatePipe z_in;
    public SolZlibDeflatePipe z_out;
    private final int solCompressionLevel;
    private ByteBuffer outNetBuffer;

    protected ZSmfClient(AuthenticationSchemeParameters authParams, JCSMPSessionStats sessionStats, IOReactor reactor, int zipLevel) {
        super(authParams, sessionStats, reactor, false);
        this.solCompressionLevel = zipLevel;
        this.outNetBuffer = ByteBuffer.allocate(4096);
    }

    private int getSafeZlibOutputLen(int input) {
        return (int)Math.ceil((double)input * 1.14) + 256;
    }

    public void open() throws UnknownHostException, JCSMPException, IOException {
        super.open();
        this.z_in = new SolZlibDeflatePipe(this.solCompressionLevel);
        this.z_out = new SolZlibDeflatePipe(this.solCompressionLevel);
        this.outNetBuffer = ByteBuffer.allocate(4096);
    }

    public void doPostNoResponse(WireMessage request, boolean setAuth) throws JCSMPException, IOException {
        if (!this.connected()) {
            this.open();
        }
        if (setAuth) {
            this.setAuth(request);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wirehandler.writeMessage(baos, request);
        byte[] smfdata = baos.toByteArray();
        int outLen = this.getSafeZlibOutputLen(smfdata.length);
        byte[] zlibdata = new byte[outLen];
        int compressed_output = (int)this.z_out.deflateAndFlush(smfdata, 0, smfdata.length, zlibdata, 0, zlibdata.length);
        OutputStream ostr = this.socket.getOutputStream();
        ostr.write(zlibdata, 0, compressed_output);
        ostr.flush();
        this.m_bytesWrittenCtr.addAndGet(compressed_output);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, smfdata.length);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT, compressed_output);
    }

    protected ByteBuffer[] getOutputBufferForSend(ByteBuffer[] requestBB, WireMessage request, WireMessageHandler wirehandler) throws IOException {
        ByteBuffer[] outBufLocal = null;
        byte[] outMessageData = null;
        if (request != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            wirehandler.writeMessage(baos, request);
            outMessageData = baos.toByteArray();
        } else if (requestBB != null) {
            outMessageData = new byte[ZSmfClient.remainingBytes(requestBB)];
            int i = 0;
            for (ByteBuffer b : requestBB) {
                int len = b.remaining();
                b.get(outMessageData, i, len);
                i += len;
            }
        } else {
            throw new IllegalArgumentException("No request.");
        }
        int outLen = this.getSafeZlibOutputLen(outMessageData.length);
        byte[] zlibdata = new byte[outLen];
        int compressed_output = (int)this.z_out.deflateAndFlush(outMessageData, 0, outMessageData.length, zlibdata, 0, zlibdata.length);
        outBufLocal = new ByteBuffer[]{ByteBuffer.wrap(zlibdata, 0, compressed_output)};
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT, compressed_output);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, outMessageData.length);
        return outBufLocal;
    }

    protected boolean servicePriorityQueuedData() {
        try {
            while (this._priorityData.hasWork()) {
                ByteBuffer b = this._priorityData.dequeue();
                ByteBuffer[] b_compressed = this.getOutputBufferForSend(new ByteBuffer[]{b}, null, null);
                this.enqueueForNetOutput(b_compressed);
            }
        }
        catch (IOException e) {
            this._clientException = e;
        }
        return true;
    }

    public void readMessage(InputStream istr, WireMessage msg) throws IOException {
        byte[] zlibdata = new byte[4096];
        byte[] inflateddata = new byte[4096];
        int decompressed = 0;
        int compressed = 0;
        int consumed = 0;
        while (!NioSmfUtil.isSmfMessageAvailableAtCurrentPos(this.bbWrapTmp(inflateddata, 0, decompressed))) {
            int cnt_read;
            if ((compressed += (cnt_read = istr.read(zlibdata, compressed, 1))) == zlibdata.length) {
                zlibdata = BufferUtil.growBuffer(zlibdata, zlibdata.length, zlibdata.length * 2);
            }
            int dec_pass = 0;
            boolean done = false;
            do {
                SolZlibCallResult ret = this.z_in.inflateChunks(zlibdata, consumed, compressed, inflateddata, decompressed, inflateddata.length);
                if (ret.bytes_output == -1) {
                    throw new IOException(JCSMPRB.BUNDLE.getStringSafely("Zlib.streamError"));
                }
                dec_pass = ret.bytes_output;
                consumed += ret.bytes_consumed;
                if ((decompressed += dec_pass) == inflateddata.length) {
                    inflateddata = BufferUtil.growBuffer(inflateddata, inflateddata.length, inflateddata.length * 2);
                    continue;
                }
                if (ret.bytes_consumed != 0 || ret.bytes_output != 0) continue;
                done = true;
            } while (!done);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(inflateddata, 0, decompressed);
        this.wirehandler.readMessage(is, msg);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, decompressed);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED, compressed);
    }

    private ByteBuffer bbWrapTmp(byte[] data, int offset, int length) {
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueForNetOutput(ByteBuffer[] bufs) {
        Object object = this._stateLock;
        synchronized (object) {
            int bytes_to_wr = ZSmfClient.remainingBytes(bufs);
            if (bytes_to_wr > this.outNetBuffer.remaining()) {
                int new_sz = (int)((double)(this.outNetBuffer.position() + bytes_to_wr) * 1.25);
                ByteBuffer b = ByteBuffer.allocate(new_sz);
                this.outNetBuffer.flip();
                b.put(this.outNetBuffer);
                this.outNetBuffer = b;
            }
            for (ByteBuffer src : bufs) {
                this.outNetBuffer.put(src);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeLoop(boolean allowReg, boolean dropOnWouldBlock) {
        long out_data_remaining = 0L;
        long out_data_written = 0L;
        Object object = this._stateLock;
        synchronized (object) {
            boolean wrote_everything;
            block12: {
                this.outNetBuffer.flip();
                out_data_remaining = this.outNetBuffer.remaining();
                if (out_data_remaining > 0L) {
                    try {
                        out_data_written = this.socket.getChannel().write(this.outNetBuffer);
                        this.m_bytesWrittenCtr.addAndGet(out_data_written);
                    }
                    catch (IOException ex) {
                        this._clientException = ex;
                    }
                    catch (NotYetConnectedException ex) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError();
                    }
                }
            }
            this.outNetBuffer.compact();
            long bytes_remaining = out_data_remaining - out_data_written;
            boolean bl = wrote_everything = bytes_remaining == 0L;
            if (this._clientException != null || wrote_everything) {
                if (!allowReg) {
                    this._reactor.deregisterHandler(this, 4);
                }
                this._writeCompleteSem.release();
            } else if (allowReg && !wrote_everything) {
                this._reactor.registerHandler(this, 4);
                if (dropOnWouldBlock) {
                    Trace.debug((Object)String.format("(smfclient %s) Buffering low-priority write request (would block)", this._smfClientId));
                    this._writeCompleteSem.release();
                    return 1;
                }
            }
        }
        return 0;
    }
}

