/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlBuilder {
    private StringBuilder builder;
    private boolean firstParam = true;

    public void start(String baseUri) {
        baseUri = baseUri.trim();
        if (this.builder == null) {
            this.builder = new StringBuilder();
        } else {
            this.builder.delete(0, this.builder.length());
        }
        this.builder.append(baseUri);
    }

    public void addParams(String key, String[] values) {
        for (String val : values) {
            this.addParam(key, val);
        }
    }

    public void addParam(String key, String value) {
        try {
            value = URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException ignore) {
            ignore.printStackTrace();
        }
        if (this.firstParam) {
            this.firstParam = false;
            this.builder.append("?");
        } else {
            this.builder.append("&");
        }
        this.builder.append(key);
        this.builder.append("=");
        this.builder.append(value);
    }

    public String toString() {
        return this.builder.toString();
    }
}

