/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.content.Context;
import com.socialize.log.SocializeLogger;
import com.socialize.util.ClassLoaderProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ResourceLocator {
    private ClassLoaderProvider classLoaderProvider = new ClassLoaderProvider();
    private SocializeLogger logger;

    public InputStream locateInAssets(Context context, String name) throws IOException {
        InputStream in;
        block4: {
            in = null;
            try {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Looking for " + name + " in asset path...");
                }
                if ((in = context.getAssets().open(name)) != null && this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Found " + name + " in asset path");
                }
            }
            catch (IOException ignore) {
                if (this.logger == null || !this.logger.isDebugEnabled()) break block4;
                this.logger.debug("No file found in assets with name [" + name + "].");
            }
        }
        return in;
    }

    public InputStream locateInLocalStorage(Context context, String name) throws IOException {
        try {
            return context.openFileInput(name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public InputStream locateInClassPath(Context context, String name) throws IOException {
        InputStream in = null;
        if (this.classLoaderProvider != null) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Looking for " + name + " in classpath...");
            }
            if ((in = this.classLoaderProvider.getClassLoader().getResourceAsStream(name)) != null && this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Found " + name + " in classpath");
            }
        }
        return in;
    }

    public InputStream locate(Context context, String name) throws IOException {
        InputStream in = this.locateInAssets(context, name);
        if (in == null) {
            in = this.locateInClassPath(context, name);
        }
        if (in == null) {
            in = this.locateInLocalStorage(context, name);
        }
        if (in == null) {
            if (this.logger != null) {
                this.logger.error("Could not locate [" + name + "] in any location");
            } else {
                FileNotFoundException e = new FileNotFoundException("Could not locate [" + name + "] in any location");
                SocializeLogger.e(e.getMessage(), e);
            }
        }
        return in;
    }

    public ClassLoaderProvider getClassLoaderProvider() {
        return this.classLoaderProvider;
    }

    public void setClassLoaderProvider(ClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    public SocializeLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

