/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.content.Context;
import android.net.Uri;
import android.util.SparseArray;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.util.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.http.HttpResponse;

public class HttpUtils {
    private ResourceLocator resourceLocator;
    private SocializeLogger logger;
    final SparseArray<String> httpStatusCodes = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context) {
        InputStream in = null;
        try {
            in = this.resourceLocator.locate(context, "socialize.errors.properties");
            Properties props = new Properties();
            props.load(in);
            Set<Object> keys = props.keySet();
            for (Object object : keys) {
                try {
                    int code = Integer.parseInt(object.toString());
                    String msg = props.getProperty(object.toString());
                    this.httpStatusCodes.put(code, (Object)msg);
                }
                catch (NumberFormatException e) {
                    if (this.logger == null || !this.logger.isWarnEnabled()) continue;
                    this.logger.warn(object.toString() + " is not an integer");
                }
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error(5, (Throwable)e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isHttpError(HttpResponse response) {
        return this.isHttpError(response.getStatusLine().getStatusCode());
    }

    public boolean isAuthError(HttpResponse response) {
        return this.isAuthError(response.getStatusLine().getStatusCode());
    }

    public boolean isAuthError(SocializeException error) {
        if (error instanceof SocializeApiError) {
            SocializeApiError sError = (SocializeApiError)error;
            return this.isAuthError(sError.getResultCode());
        }
        return false;
    }

    public boolean isAuthError(int code) {
        return code == 401 || code == 403;
    }

    public boolean isHttpError(int code) {
        return code >= 400;
    }

    public String getMessageFor(int code) {
        return (String)this.httpStatusCodes.get(code);
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public Uri toURI(String url) {
        return Uri.parse((String)url);
    }
}

