/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import com.socialize.log.SocializeLogger;

public class DisplayUtils {
    private SocializeLogger logger;
    private float density = 1.0f;
    private int orientation;
    private int displayHeight;
    private int displayWidth;

    public void init(Context context) {
        if (context instanceof Activity) {
            DisplayMetrics metrics = new DisplayMetrics();
            Display display = ((Activity)context).getWindowManager().getDefaultDisplay();
            display.getMetrics(metrics);
            this.density = metrics.density;
            this.displayHeight = display.getHeight();
            this.displayWidth = display.getWidth();
            this.orientation = this.displayWidth == this.displayHeight ? 3 : (this.displayWidth < this.displayHeight ? 1 : 2);
        } else {
            String errroMsg = "Unable to determine device screen density.  Socialize must be intialized from an Activity";
            if (this.logger != null) {
                this.logger.warn(errroMsg);
            } else {
                System.err.println(errroMsg);
            }
        }
    }

    public int getDIP(float pixels) {
        return this.getDIP(Math.round(pixels));
    }

    public int getDIP(int pixels) {
        if (pixels != 0) {
            return (int)((float)pixels * this.density);
        }
        return pixels;
    }

    public boolean isLowRes() {
        return this.density <= 1.0f;
    }

    public boolean isLDPI() {
        return this.density <= 0.75f;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isLandscape() {
        return this.orientation == 2;
    }
}

