/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.InputFilter;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;

public class SocializeEditText
extends LinearLayout {
    private DisplayUtils displayUtils;
    private Colors colors;
    private String label;
    private String text;
    private TextView objLabel;
    private EditText objEdit;
    private InputFilter[] filters;

    public SocializeEditText(Context context) {
        super(context);
    }

    public void init() {
        int padding = this.displayUtils.getDIP(8);
        int editTextStroke = this.displayUtils.getDIP(2);
        float editTextRadius = editTextStroke;
        this.setOrientation(1);
        GradientDrawable textBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("TEXT_BG"), this.colors.getColor("TEXT_BG")});
        textBG.setStroke(editTextStroke, this.colors.getColor("TEXT_STROKE"));
        textBG.setCornerRadius(editTextRadius);
        this.objEdit = new EditText(this.getContext());
        this.objEdit.setMinLines(1);
        this.objEdit.setMaxLines(1);
        this.objEdit.setSingleLine(true);
        this.objEdit.setTextSize(1, 16.0f);
        this.objEdit.setTextColor(-16777216);
        if (this.text != null) {
            this.objEdit.setText((CharSequence)this.text);
        }
        if (this.filters != null) {
            this.objEdit.setFilters(this.filters);
        }
        this.objLabel = new TextView(this.getContext());
        this.objLabel.setMinLines(1);
        this.objLabel.setMaxLines(1);
        this.objLabel.setSingleLine(true);
        this.objLabel.setTextSize(1, 12.0f);
        this.objLabel.setTextColor(-1);
        if (this.label != null) {
            this.objLabel.setText((CharSequence)this.label);
        }
        CompatUtils.setBackgroundDrawable((View)this.objEdit, (Drawable)textBG);
        this.objEdit.setPadding(padding, padding, padding, padding);
        this.addView((View)this.objLabel);
        this.addView((View)this.objEdit);
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.objLabel != null) {
            this.objLabel.setText((CharSequence)label);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.objEdit != null) {
            this.objEdit.setText((CharSequence)text);
        }
    }

    public String getText() {
        if (this.objEdit != null) {
            return this.objEdit.getText().toString();
        }
        return this.text;
    }

    public void setFilters(InputFilter[] filters) {
        this.filters = filters;
        if (this.objEdit != null) {
            this.objEdit.setFilters(filters);
        }
    }
}

