/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.ui.view.BasicLoadingView;
import com.socialize.ui.view.LoadingView;
import com.socialize.ui.view.SafeViewFlipper;

public abstract class BaseLoadingView<V extends View>
extends SafeViewFlipper
implements LoadingView<V> {
    private V mainView;
    private TextView emptyTextView;
    private IBeanFactory<BasicLoadingView> loadingViewFactory;
    private String emptyText = "No data";

    public BaseLoadingView(Context context) {
        super(context);
    }

    public void init() {
        LinearLayout contentView = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams contentViewLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        contentView.setLayoutParams((ViewGroup.LayoutParams)contentViewLayoutParams);
        contentView.setOrientation(1);
        LinearLayout.LayoutParams emptyContentLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.emptyTextView = new TextView(this.getContext());
        this.emptyTextView.setLayoutParams((ViewGroup.LayoutParams)emptyContentLayoutParams);
        this.emptyTextView.setGravity(17);
        this.emptyTextView.setText((CharSequence)this.emptyText);
        this.mainView = this.createMainView();
        contentView.addView(this.mainView);
        LinearLayout.LayoutParams flipperLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        flipperLayoutParams.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)flipperLayoutParams);
        BasicLoadingView loadingScreen = (BasicLoadingView)((Object)this.loadingViewFactory.getBean());
        if (loadingScreen != null) {
            this.addView((View)loadingScreen);
        }
        this.addView((View)contentView);
        this.addView((View)this.emptyTextView);
        this.showLoading();
    }

    @Override
    public void showLoading() {
        this.setDisplayedChild(0);
    }

    @Override
    public void showList() {
        this.setDisplayedChild(1);
    }

    @Override
    public void showEmptyText() {
        this.setDisplayedChild(2);
    }

    public void setLoadingViewFactory(IBeanFactory<BasicLoadingView> loadingViewFactory) {
        this.loadingViewFactory = loadingViewFactory;
    }

    @Override
    public String getEmptyText() {
        return this.emptyText;
    }

    @Override
    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
        if (this.emptyTextView != null) {
            this.emptyTextView.setText((CharSequence)emptyText);
        }
    }

    @Override
    public V getMainView() {
        return this.mainView;
    }

    protected abstract V createMainView();
}

