/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.share;

import android.app.Dialog;
import android.content.Context;
import com.socialize.Socialize;
import com.socialize.android.ioc.BeanCreationListener;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.event.EventSystem;
import com.socialize.api.event.SocializeEvent;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.ui.dialog.AsyncDialogFactory;
import com.socialize.ui.share.DialogFlowController;
import com.socialize.ui.share.IShareDialogFactory;
import com.socialize.ui.share.ShareDialogListener;
import com.socialize.ui.share.SharePanelView;
import org.json.JSONArray;
import org.json.JSONObject;

public class ShareDialogFactory
extends AsyncDialogFactory<SharePanelView, ShareDialogListener>
implements IShareDialogFactory {
    private EventSystem eventSystem;
    private SocializeConfig config;

    @Override
    public void preload(Context context) {
        super.preload(context, new Object[0]);
    }

    @Override
    public void show(Context context, final Entity entity, final SocialNetworkListener socialNetworkListener, final ShareDialogListener shareDialoglistener, final int displayOptions) {
        this.showDialog(context, new BeanCreationListener<SharePanelView>(){

            public void onError(String name, Exception e) {
            }

            public void onCreate(SharePanelView bean) {
                bean.setSocialNetworkListener(socialNetworkListener);
                bean.setEntity(entity);
                bean.setShareDialogListener(shareDialoglistener);
                bean.setDisplayOptions(displayOptions);
                bean.applyDisplayOptions();
                bean.updateNetworkButtonState();
            }
        }, new ShareDialogListener(){

            @Override
            public void onShow(Dialog dialog, SharePanelView dialogView) {
                ShareDialogFactory.this.recordEvent("show", new String[0]);
                if (shareDialoglistener != null) {
                    shareDialoglistener.onShow(dialog, dialogView);
                }
            }

            @Override
            public void onSimpleShare(ShareType type) {
                ShareDialogFactory.this.recordEvent("share", type.name());
                if (shareDialoglistener != null) {
                    shareDialoglistener.onSimpleShare(type);
                }
            }

            @Override
            public void onCancel(Dialog dialog) {
                ShareDialogFactory.this.recordEvent("close", new String[0]);
                if (shareDialoglistener != null) {
                    shareDialoglistener.onCancel(dialog);
                }
            }

            @Override
            public boolean onContinue(Dialog dialog, boolean remember, SocialNetwork ... networks) {
                ShareDialogFactory.this.recordEvent("share", networks);
                return shareDialoglistener != null && shareDialoglistener.onContinue(dialog, remember, networks);
            }

            @Override
            public void onFlowInterrupted(DialogFlowController controller) {
                if (shareDialoglistener != null) {
                    shareDialoglistener.onFlowInterrupted(controller);
                }
            }
        }, new Object[0]);
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    protected void recordEvent(String action, SocialNetwork[] networks) {
        if (networks != null && networks.length > 0) {
            String[] strNets = new String[networks.length];
            for (int i = 0; i < networks.length; ++i) {
                strNets[i] = networks[i].name();
            }
            this.recordEvent(action, strNets);
        } else {
            this.recordEvent(action, new String[0]);
        }
    }

    protected void recordEvent(final String action, final String ... networks) {
        new Thread(){

            @Override
            public void run() {
                block6: {
                    if (ShareDialogFactory.this.eventSystem != null && ShareDialogFactory.this.config != null && ShareDialogFactory.this.config.getBooleanProperty("socialize.events.share.enabled", true)) {
                        try {
                            SocializeSession session = Socialize.getSocialize().getSession();
                            if (session != null) {
                                SocializeEvent event = new SocializeEvent();
                                event.setBucket("SHARE_DIALOG");
                                JSONObject json = new JSONObject();
                                json.put("action", (Object)action);
                                if (networks != null && networks.length > 0) {
                                    JSONArray array = new JSONArray();
                                    for (String string : networks) {
                                        array.put((Object)string);
                                    }
                                    json.put("network", (Object)array);
                                }
                                event.setData(json);
                                ShareDialogFactory.this.eventSystem.addEvent(session, event, null);
                            }
                        }
                        catch (Throwable e) {
                            if (ShareDialogFactory.this.logger == null) break block6;
                            ShareDialogFactory.this.logger.warn("Error recording share dialog event", e);
                        }
                    }
                }
            }
        }.start();
    }

    public void setEventSystem(EventSystem eventSystem) {
        this.eventSystem = eventSystem;
    }
}

