/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.socialize.entity.JSONFactory;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.BitmapUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class UserSettingsFactory
extends JSONFactory<UserSettings> {
    public static final String FIRST_NAME = "first_name";
    public static final String LAST_NAME = "last_name";
    public static final String IMAGE_DATA = "picture";
    public static final String AUTO_POST_FACEBOOK = "auto_post_fb";
    public static final String AUTO_POST_TWITTER = "auto_post_tw";
    public static final String NOTIFICATIONS_ENABLED = "notifications_enabled";
    public static final String SHARE_LOCATION = "share_location";
    public static final String SHOW_AUTH = "show_auth_dialog";
    private BitmapUtils bitmapUtils;

    @Override
    public Object instantiateObject(JSONObject object) {
        return new UserSettings();
    }

    @Override
    protected void fromJSON(JSONObject object, UserSettings user) throws JSONException {
        user.setFirstName(this.getString(object, FIRST_NAME));
        user.setLastName(this.getString(object, LAST_NAME));
        user.setAutoPostFacebook(this.getBoolean(object, AUTO_POST_FACEBOOK, false));
        user.setAutoPostTwitter(this.getBoolean(object, AUTO_POST_TWITTER, false));
        user.setLocationEnabled(this.getBoolean(object, SHARE_LOCATION, true));
        user.setNotificationsEnabled(this.getBoolean(object, NOTIFICATIONS_ENABLED, true));
        user.setShowAuthDialog(this.getBoolean(object, SHOW_AUTH, true));
    }

    @Override
    protected void toJSON(UserSettings user, JSONObject object) throws JSONException {
        String encoded = null;
        try {
            if (user.getImage() != null) {
                encoded = this.bitmapUtils.encode(user.getImage());
            } else if (user.getLocalImagePath() != null) {
                BitmapFactory.Options bfo = new BitmapFactory.Options();
                bfo.inDither = true;
                bfo.inSampleSize = 4;
                Bitmap bm = BitmapFactory.decodeFile((String)user.getLocalImagePath(), (BitmapFactory.Options)bfo);
                encoded = this.bitmapUtils.encode(bm);
                bm.recycle();
                user.setLocalImagePath(null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        object.put(FIRST_NAME, (Object)user.getFirstName());
        object.put(LAST_NAME, (Object)user.getLastName());
        if (encoded != null) {
            object.put(IMAGE_DATA, (Object)encoded);
        }
        object.put(AUTO_POST_FACEBOOK, user.isAutoPostFacebook());
        object.put(AUTO_POST_TWITTER, user.isAutoPostTwitter());
        object.put(SHARE_LOCATION, user.isLocationEnabled());
        object.put(NOTIFICATIONS_ENABLED, user.isNotificationsEnabled());
        object.put(SHOW_AUTH, user.isShowAuthDialog());
    }

    public void setBitmapUtils(BitmapUtils bitmapUtils) {
        this.bitmapUtils = bitmapUtils;
    }
}

