/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.graphics.Bitmap;
import com.socialize.entity.User;
import com.socialize.networks.SocialNetwork;
import java.io.Serializable;

public class UserSettings
implements Serializable {
    private static final long serialVersionUID = -7230021028577349407L;
    private String fullName;
    private String firstName;
    private String lastName;
    private Bitmap image;
    private String localImagePath;
    private boolean notificationsEnabled = true;
    private boolean locationEnabled = true;
    private boolean autoPostFacebook = false;
    private boolean autoPostTwitter = false;
    private boolean showAuthDialog = true;

    public String getFullName() {
        if (this.fullName == null) {
            return this.joinName();
        }
        return this.fullName;
    }

    public Bitmap getImage() {
        return this.image;
    }

    public void setImage(Bitmap image) {
        this.image = image;
    }

    public String getFirstName() {
        if (this.firstName == null) {
            this.splitName();
        }
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        if (this.lastName == null) {
            this.splitName();
        }
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    protected void splitName() {
        if (this.fullName != null) {
            String name;
            this.firstName = name = this.fullName;
            String[] names = (name = name.trim()).split("\\s+");
            if (names.length > 1) {
                this.firstName = names[0];
                this.lastName = name.substring(this.firstName.length(), name.length()).trim();
            }
        }
    }

    protected String joinName() {
        if (this.firstName != null || this.lastName != null) {
            this.fullName = this.firstName == null ? this.lastName : (this.lastName == null ? this.firstName : this.firstName + " " + this.lastName);
        }
        return this.fullName;
    }

    public boolean isAutoPostFacebook() {
        return this.autoPostFacebook;
    }

    public void setAutoPostFacebook(boolean autoPostFacebook) {
        this.autoPostFacebook = autoPostFacebook;
    }

    public boolean isAutoPostTwitter() {
        return this.autoPostTwitter;
    }

    public void setAutoPostTwitter(boolean autoPostTwitter) {
        this.autoPostTwitter = autoPostTwitter;
    }

    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void setNotificationsEnabled(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    public boolean isLocationEnabled() {
        return this.locationEnabled;
    }

    public void setLocationEnabled(boolean locationEnabled) {
        this.locationEnabled = locationEnabled;
    }

    public boolean isShowAuthDialog() {
        return this.showAuthDialog;
    }

    public void setShowAuthDialog(boolean showAuthDialog) {
        this.showAuthDialog = showAuthDialog;
    }

    public String getLocalImagePath() {
        return this.localImagePath;
    }

    public void setLocalImagePath(String localImagePath) {
        this.localImagePath = localImagePath;
    }

    public void update(User user) {
        this.setFirstName(user.getFirstName());
        this.setLastName(user.getLastName());
    }

    public void update(UserSettings other) {
        this.setAutoPostFacebook(other.isAutoPostFacebook());
        this.setAutoPostTwitter(other.isAutoPostTwitter());
        this.setFirstName(other.getFirstName());
        this.setLastName(other.getLastName());
        this.setLocationEnabled(other.isLocationEnabled());
        this.setNotificationsEnabled(other.isNotificationsEnabled());
        this.setShowAuthDialog(other.isShowAuthDialog());
    }

    public boolean setAutoPostPreferences(SocialNetwork ... networks) {
        boolean tw = this.isAutoPostTwitter();
        boolean fb = this.isAutoPostFacebook();
        this.setAutoPostFacebook(false);
        this.setAutoPostTwitter(false);
        if (networks != null) {
            for (SocialNetwork network : networks) {
                if (network.equals((Object)SocialNetwork.FACEBOOK)) {
                    this.setAutoPostFacebook(true);
                    continue;
                }
                if (!network.equals((Object)SocialNetwork.TWITTER)) continue;
                this.setAutoPostTwitter(true);
            }
        }
        return tw != this.isAutoPostTwitter() || fb != this.isAutoPostFacebook();
    }
}

