/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.socialize.UserUtils;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.profile.ProfileLayoutView;
import com.socialize.ui.view.EntityView;

public class ProfileView
extends EntityView {
    private ProfileLayoutView profileLayoutView = null;

    public ProfileView(Activity context) {
        super((Context)context);
    }

    @Override
    protected View getView(Bundle bundle, Object ... entityKeys) {
        if (entityKeys != null) {
            if (this.profileLayoutView == null) {
                this.profileLayoutView = (ProfileLayoutView)this.container.getBean("profileLayoutView", entityKeys);
            }
            return this.profileLayoutView;
        }
        SocializeLogger.e("No user id specified for " + this.getClass().getSimpleName());
        return null;
    }

    @Override
    protected String[] getBundleKeys() {
        return new String[]{"socialize.user.id"};
    }

    public void onImageChange(Bitmap bitmap, String localPath) {
        if (this.profileLayoutView != null) {
            this.profileLayoutView.onImageChange(bitmap);
        }
        try {
            UserUtils.getUserSettings(this.getContext()).setLocalImagePath(localPath);
        }
        catch (SocializeException e) {
            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error getting user settings", (Throwable)e);
        }
    }

    @Override
    public View getLoadingView() {
        return null;
    }
}

