/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.socialize.entity.User;
import com.socialize.error.SocializeErrorHandler;
import com.socialize.error.SocializeException;
import com.socialize.listener.user.UserSaveListener;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.ui.profile.ProfileContentView;
import com.socialize.ui.profile.ProfileSaver;
import com.socialize.ui.profile.UserSettings;

public class ProfileSaveButtonListener
implements View.OnClickListener {
    private ProfileContentView view;
    private ProfileSaver profileSaver;
    private SocializeErrorHandler errorHandler;
    private ProgressDialogFactory progressDialogFactory;
    private Activity context;

    public ProfileSaveButtonListener(Activity context, ProfileContentView view) {
        this.view = view;
        this.context = context;
    }

    public void onClick(View v) {
        final ProgressDialog progress = this.progressDialogFactory.show((Context)this.context, "socialize_settings_dialog", "socialize_please_wait");
        UserSettings profile = new UserSettings();
        profile.setFirstName(this.view.getFirstNameEdit().getText().toString().trim());
        profile.setLastName(this.view.getLastNameEdit().getText().toString().trim());
        Drawable imageOn = this.view.getProfilePictureEditView().getProfileImage();
        if (imageOn instanceof BitmapDrawable) {
            profile.setImage(((BitmapDrawable)imageOn).getBitmap());
        }
        if (this.view.getAutoPostFacebook() != null) {
            profile.setAutoPostFacebook(this.view.getAutoPostFacebook().isChecked());
        }
        if (this.view.getAutoPostTwitter() != null) {
            profile.setAutoPostTwitter(this.view.getAutoPostTwitter().isChecked());
        }
        if (this.view.getNotificationsEnabledCheckbox() != null) {
            profile.setNotificationsEnabled(this.view.getNotificationsEnabledCheckbox().isChecked());
        }
        if (this.view.getLocationEnabledCheckbox() != null) {
            profile.setLocationEnabled(this.view.getLocationEnabledCheckbox().isChecked());
        }
        this.profileSaver.save((Context)this.context, profile, new UserSaveListener(){

            @Override
            public void onError(SocializeException error) {
                progress.dismiss();
                if (ProfileSaveButtonListener.this.errorHandler != null) {
                    ProfileSaveButtonListener.this.errorHandler.handleError((Context)ProfileSaveButtonListener.this.context, error);
                }
            }

            @Override
            public void onUpdate(User entity) {
                progress.dismiss();
                ProfileSaveButtonListener.this.context.setResult(1347);
                ProfileSaveButtonListener.this.context.finish();
            }
        });
    }

    public void setProfileSaver(ProfileSaver profileSaver) {
        this.profileSaver = profileSaver;
    }

    public void setErrorHandler(SocializeErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setProgressDialogFactory(ProgressDialogFactory progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }
}

