/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.User;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.image.ImageLoadListener;
import com.socialize.ui.image.ImageLoadRequest;
import com.socialize.ui.image.ImageLoader;
import com.socialize.ui.profile.ProfileImageContextMenu;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.ClickableSectionCell;
import com.socialize.util.Drawables;
import com.socialize.util.SafeBitmapDrawable;
import com.socialize.util.StringUtils;

public class ProfilePictureEditView
extends ClickableSectionCell {
    private ImageLoader imageLoader;
    private IBeanFactory<ProfileImageContextMenu> profileImageContextMenuFactory;
    private ImageView profilePicture;
    private Drawable defaultProfilePicture;

    public ProfilePictureEditView(Context context) {
        super(context);
    }

    @Override
    public void init() {
        super.init();
        this.setClickEvent();
    }

    @Override
    protected ImageView makeImage() {
        this.defaultProfilePicture = this.drawables.getDrawable("default_user_icon.png");
        this.profilePicture = new ImageView(this.getContext());
        int imageSize = this.displayUtils.getDIP(64);
        int imagePadding = this.displayUtils.getDIP(4);
        LinearLayout.LayoutParams imageLayout = new LinearLayout.LayoutParams(imageSize, imageSize);
        GradientDrawable imageBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-1, -1});
        imageBG.setStroke(2, -16777216);
        imageBG.setAlpha(64);
        this.profilePicture.setLayoutParams((ViewGroup.LayoutParams)imageLayout);
        this.profilePicture.setPadding(imagePadding, imagePadding, imagePadding, imagePadding);
        CompatUtils.setBackgroundDrawable((View)this.profilePicture, (Drawable)imageBG);
        this.profilePicture.setScaleType(ImageView.ScaleType.CENTER_CROP);
        return this.profilePicture;
    }

    protected void setClickEvent() {
        final ProfileImageContextMenu menu = (ProfileImageContextMenu)this.profileImageContextMenuFactory.getBean();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                menu.show();
            }
        });
    }

    @Override
    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setProfileImageContextMenuFactory(IBeanFactory<ProfileImageContextMenu> profileImageContextMenuFactory) {
        this.profileImageContextMenuFactory = profileImageContextMenuFactory;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public void setUserDetails(User user) {
        String profilePicData = user.getMediumImageUri();
        if (!StringUtils.isEmpty(profilePicData)) {
            this.profilePicture.getBackground().setAlpha(64);
            this.imageLoader.loadImageByUrl(profilePicData, new ImageLoadListener(){

                @Override
                public void onImageLoadFail(ImageLoadRequest request, Exception error) {
                    SocializeLogger.e(error.getMessage(), error);
                    ProfilePictureEditView.this.profilePicture.post(new Runnable(){

                        @Override
                        public void run() {
                            ProfilePictureEditView.this.profilePicture.setImageDrawable(ProfilePictureEditView.this.defaultProfilePicture);
                            ProfilePictureEditView.this.profilePicture.getBackground().setAlpha(255);
                        }
                    });
                }

                @Override
                public void onImageLoad(ImageLoadRequest request, final SafeBitmapDrawable drawable2) {
                    ProfilePictureEditView.this.profilePicture.post(new Runnable(){

                        @Override
                        public void run() {
                            drawable2.setAlpha(255);
                            ProfilePictureEditView.this.profilePicture.setImageDrawable((Drawable)drawable2);
                            ProfilePictureEditView.this.profilePicture.getBackground().setAlpha(255);
                        }
                    });
                }
            });
        } else {
            this.profilePicture.setImageDrawable(this.defaultProfilePicture);
            this.profilePicture.getBackground().setAlpha(255);
        }
    }

    public void setProfileImage(Drawable drawable2) {
        if (this.profilePicture != null) {
            this.profilePicture.setImageDrawable(drawable2);
        }
    }

    public Drawable getProfileImage() {
        if (this.profilePicture != null) {
            return this.profilePicture.getDrawable();
        }
        return null;
    }

    @Override
    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }
}

