/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.entity.User;
import com.socialize.ui.SocializeUIActivity;
import com.socialize.ui.profile.ProfileView;
import com.socialize.util.StringUtils;

public class ProfileActivity
extends SocializeUIActivity {
    public static final int CAMERA_PIC_REQUEST = 1337;
    public static final int GALLERY_PIC_REQUEST = 1338;
    private ProfileView view;

    @Override
    protected void onCreateSafe(Bundle savedInstanceState) {
        Bundle extras = this.getIntent().getExtras();
        if (extras == null || !extras.containsKey("socialize.user.id")) {
            Toast.makeText((Context)this, (CharSequence)"No user id provided", (int)0).show();
            this.finish();
        } else {
            User user;
            String userId = extras.getString("socialize.user.id");
            SocializeSession session = this.getSocialize().getSession();
            if (session != null && (user = session.getUser()) != null && !StringUtils.isEmpty(userId) && Integer.parseInt(userId) == user.getId().intValue()) {
                this.setResult(1347);
            }
            this.view = new ProfileView(this);
            this.setContentView((View)this.view);
        }
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String[] projection;
        Cursor cursor;
        Uri selectedImageUri;
        if (requestCode == 1337) {
            Bitmap thumbnail;
            Bundle extras;
            if (data != null && (extras = data.getExtras()) != null && (thumbnail = (Bitmap)extras.get("data")) != null) {
                this.view.onImageChange(thumbnail, null);
            }
        } else if (requestCode == 1338 && data != null && (selectedImageUri = data.getData()) != null && (cursor = this.managedQuery(selectedImageUri, projection = new String[]{"_data"}, null, null, null)) != null) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String path = cursor.getString(column_index);
            if (path != null) {
                BitmapFactory.Options bfo = new BitmapFactory.Options();
                bfo.inDither = true;
                bfo.inSampleSize = 4;
                Bitmap bm = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)bfo);
                if (bm != null) {
                    this.view.onImageChange(bm, path);
                }
            } else {
                Toast.makeText((Context)this, (CharSequence)"Failed to retrieve image", (int)0).show();
            }
        }
    }
}

