/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.image;

import com.socialize.ui.image.ImageLoadListener;
import com.socialize.ui.image.ImageLoadType;
import com.socialize.util.SafeBitmapDrawable;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ImageLoadRequest {
    private String encodedImageData;
    private String url;
    private ConcurrentLinkedQueue<ImageLoadListener> listeners;
    private boolean canceled;
    private boolean listenersNotified = false;
    private ImageLoadType type = ImageLoadType.URL;
    private int scaleWidth = -1;
    private int scaleHeight = -1;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isListenersNotified() {
        return this.listenersNotified;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public int notifyListeners(SafeBitmapDrawable drawable2) {
        int notified = 0;
        this.listenersNotified = true;
        if (this.listeners != null) {
            while (!this.listeners.isEmpty()) {
                if (this.isCanceled()) {
                    this.listeners.clear();
                    break;
                }
                ImageLoadListener listener = this.listeners.poll();
                listener.onImageLoad(this, drawable2);
                ++notified;
            }
        }
        return notified;
    }

    public void notifyListeners(Exception error) {
        this.listenersNotified = true;
        if (this.listeners != null) {
            while (!this.listeners.isEmpty()) {
                if (this.isCanceled()) {
                    this.listeners.clear();
                    break;
                }
                ImageLoadListener listener = this.listeners.poll();
                listener.onImageLoadFail(this, error);
            }
        }
    }

    public void merge(ImageLoadRequest request) {
        this.addListeners(request.listeners);
    }

    public synchronized void addListeners(Collection<ImageLoadListener> listener) {
        if (listener != null && listener.size() > 0) {
            if (this.listeners == null) {
                this.listeners = new ConcurrentLinkedQueue();
            }
            this.listeners.addAll(listener);
        }
    }

    public synchronized void addListener(ImageLoadListener listener) {
        if (this.listeners == null) {
            this.listeners = new ConcurrentLinkedQueue();
        }
        this.listeners.add(listener);
    }

    public String getEncodedImageData() {
        return this.encodedImageData;
    }

    public void setEncodedImageData(String encodedImageData) {
        this.encodedImageData = encodedImageData;
    }

    public ImageLoadType getType() {
        return this.type;
    }

    public void setType(ImageLoadType type) {
        this.type = type;
    }

    public int getScaleWidth() {
        return this.scaleWidth;
    }

    public void setScaleWidth(int scaleWidth) {
        this.scaleWidth = scaleWidth;
    }

    public int getScaleHeight() {
        return this.scaleHeight;
    }

    public void setScaleHeight(int scaleHeight) {
        this.scaleHeight = scaleHeight;
    }

    public Queue<ImageLoadListener> getListeners() {
        return this.listeners;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageLoadRequest other = (ImageLoadRequest)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

