/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.error;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeErrorHandler;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.DialogRegistration;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;

public class DialogErrorHandler
implements SocializeErrorHandler {
    private Drawables drawables;
    private String message;

    @Override
    public void handleError(Context context, Exception e) {
        SocializeLogger.e("", e);
        String message = "An unexpected error occurred.  Please try again";
        if (e instanceof SocializeApiError) {
            int code = ((SocializeApiError)e).getResultCode();
            message = code == 500 ? message + "\n\nServer Error (" + code + ")" : message + "\n\n" + e.getMessage();
        }
        this.handleError(context, message);
    }

    protected void handleError(Context context, String message) {
        try {
            AlertDialog.Builder builder = this.makeBuilder(context);
            builder.setTitle((CharSequence)"Error");
            if (this.drawables != null) {
                builder.setIcon(this.drawables.getDrawable("socialize_icon_white.png"));
            }
            if (!StringUtils.isEmpty(message)) {
                builder.setMessage((CharSequence)message);
            } else {
                builder.setMessage((CharSequence)this.message);
            }
            builder.setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    dialog.dismiss();
                }
            });
            AlertDialog alert = builder.create();
            DialogRegistration.register(context, (Dialog)alert);
            alert.show();
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)("Error displaying dialog, original message was [" + message + "]"), (Throwable)e);
        }
    }

    protected AlertDialog.Builder makeBuilder(Context context) {
        return new AlertDialog.Builder(context);
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

