/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.dialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.socialize.ui.dialog.DialogRegistration;
import com.socialize.ui.dialog.SimpleDialogFactory;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;

public class AlertDialogFactory
implements SimpleDialogFactory<AlertDialog> {
    private Drawables drawables;
    private Toast toast;

    @Override
    public AlertDialog show(Context context, String title, String message) {
        AlertDialog.Builder builder = this.makeBuilder(context);
        builder.setTitle((CharSequence)title);
        if (this.drawables != null) {
            builder.setIcon(this.drawables.getDrawable("socialize_icon_white.png"));
        }
        if (!StringUtils.isEmpty(message)) {
            builder.setMessage((CharSequence)message);
        }
        builder.setCancelable(true).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
            }
        });
        AlertDialog alert = builder.create();
        DialogRegistration.register(context, (Dialog)alert);
        alert.show();
        return alert;
    }

    public void showToast(Context context, String message) {
        if (this.toast != null) {
            this.toast.cancel();
        }
        this.toast = Toast.makeText((Context)context, (CharSequence)message, (int)0);
        this.toast.show();
    }

    protected AlertDialog.Builder makeBuilder(Context context) {
        return new AlertDialog.Builder(context);
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }
}

