/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.entity.Comment;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.comment.CommentListItemBackgroundFactory;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.CachedImageView;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;

public class CommentListItem
extends LinearLayout {
    private TextView commentText;
    private TextView time;
    private TextView author;
    private CachedImageView userIcon;
    private ImageView locationIcon;
    private DisplayUtils displayUtils;
    private Colors colors;
    private Drawables drawables;
    private SocializeLogger logger;
    private Comment commentObject;
    private boolean deleteOk = false;
    private LinearLayout contentLayout;
    private LinearLayout iconLayout;
    private CommentListItemBackgroundFactory backgroundFactory;

    public CommentListItem(Context context) {
        super(context);
    }

    public void init() {
        int eight = this.displayUtils.getDIP(8);
        int four = this.displayUtils.getDIP(4);
        int imagePadding = this.displayUtils.getDIP(2);
        int textColor = this.colors.getColor("COMMENT_BODY");
        int titleColor = this.colors.getColor("COMMENT_TITLE");
        int iconSize = this.displayUtils.getDIP(64);
        AbsListView.LayoutParams layout = new AbsListView.LayoutParams(-1, -2);
        this.setBackgroundColor(this.colors.getColor("LIST_ITEM_BG"));
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)layout);
        this.setGravity(48);
        this.setPadding(eight, eight, eight, eight);
        this.contentLayout = new LinearLayout(this.getContext());
        this.contentLayout.setOrientation(1);
        this.contentLayout.setGravity(3);
        this.contentLayout.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams contentLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        contentLayoutParams.setMargins(four, 0, 0, 0);
        this.contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentLayoutParams);
        LinearLayout contentHeaderLayout = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams contentHeaderLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        contentHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)contentHeaderLayoutParams);
        contentHeaderLayout.setGravity(3);
        contentHeaderLayout.setOrientation(0);
        contentHeaderLayout.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams authorLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        authorLayoutParams.weight = 1.0f;
        this.author = new TextView(this.getContext());
        this.author.setTextSize(1, 16.0f);
        this.author.setMaxLines(1);
        this.author.setTypeface(Typeface.DEFAULT_BOLD);
        this.author.setTextColor(titleColor);
        this.author.setLayoutParams((ViewGroup.LayoutParams)authorLayoutParams);
        this.author.setSingleLine();
        LinearLayout.LayoutParams commentLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.commentText = new TextView(this.getContext());
        this.commentText.setTextSize(1, 14.0f);
        this.commentText.setTextColor(textColor);
        this.commentText.setLayoutParams((ViewGroup.LayoutParams)commentLayoutParams);
        LinearLayout.LayoutParams timeLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.time = new TextView(this.getContext());
        this.time.setTextSize(1, 12.0f);
        this.time.setMaxLines(1);
        this.time.setTypeface(Typeface.DEFAULT, 2);
        this.time.setTextColor(titleColor);
        this.time.setLayoutParams((ViewGroup.LayoutParams)timeLayoutParams);
        this.time.setSingleLine();
        this.time.setGravity(5);
        LinearLayout.LayoutParams locationIconParams = new LinearLayout.LayoutParams(-2, -2);
        locationIconParams.gravity = 21;
        this.locationIcon = new ImageView(this.getContext());
        this.locationIcon.setImageDrawable(this.drawables.getDrawable("icon_location_pin.png"));
        this.locationIcon.setLayoutParams((ViewGroup.LayoutParams)locationIconParams);
        LinearLayout.LayoutParams metaParams = new LinearLayout.LayoutParams(-2, -2);
        metaParams.gravity = 53;
        LinearLayout meta = new LinearLayout(this.getContext());
        meta.setOrientation(0);
        meta.setLayoutParams((ViewGroup.LayoutParams)metaParams);
        meta.addView((View)this.time);
        meta.addView((View)this.locationIcon);
        contentHeaderLayout.addView((View)this.author);
        contentHeaderLayout.addView((View)meta);
        this.contentLayout.addView((View)contentHeaderLayout);
        this.contentLayout.addView((View)this.commentText);
        LinearLayout.LayoutParams iconLayoutParams = new LinearLayout.LayoutParams(iconSize, iconSize);
        iconLayoutParams.gravity = 49;
        this.iconLayout = new LinearLayout(this.getContext());
        this.iconLayout.setLayoutParams((ViewGroup.LayoutParams)iconLayoutParams);
        this.iconLayout.setGravity(49);
        this.userIcon = new CachedImageView(this.getContext());
        this.userIcon.setDrawables(this.drawables);
        this.userIcon.setLogger(this.logger);
        this.userIcon.setDefaultImage();
        this.userIcon.setLayoutParams((ViewGroup.LayoutParams)iconLayoutParams);
        this.userIcon.setPadding(imagePadding, imagePadding, imagePadding, imagePadding);
        GradientDrawable imageBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-1, -1});
        imageBG.setStroke(this.displayUtils.getDIP(1), -16777216);
        CompatUtils.setBackgroundDrawable(this.userIcon, (Drawable)imageBG);
        this.iconLayout.addView((View)this.userIcon);
        this.addView((View)this.iconLayout);
        this.addView((View)this.contentLayout);
    }

    public TextView getCommentText() {
        return this.commentText;
    }

    public TextView getTime() {
        return this.time;
    }

    public TextView getAuthor() {
        return this.author;
    }

    public CachedImageView getUserIcon() {
        return this.userIcon;
    }

    public ImageView getLocationIcon() {
        return this.locationIcon;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setBackgroundFactory(CommentListItemBackgroundFactory backgroundFactory) {
        this.backgroundFactory = backgroundFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public Comment getCommentObject() {
        return this.commentObject;
    }

    public void setCommentObject(Comment commentObject) {
        this.commentObject = commentObject;
    }

    public boolean isDeleteOk() {
        return this.deleteOk;
    }

    public void setDeleteOk(boolean deleteOk) {
        this.deleteOk = deleteOk;
    }

    public LinearLayout getContentLayout() {
        return this.contentLayout;
    }

    public LinearLayout getIconLayout() {
        return this.iconLayout;
    }
}

