/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.i18n.LocalizationService;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;

public class CommentEditField
extends LinearLayout {
    private DisplayUtils displayUtils;
    private Colors colors;
    private TextView editText;
    private LocalizationService localizationService;

    public CommentEditField(Context context) {
        super(context);
    }

    public void init() {
        int four = this.displayUtils.getDIP(4);
        int eight = this.displayUtils.getDIP(8);
        LinearLayout.LayoutParams editPanelLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        editPanelLayoutParams.setMargins(four, eight, eight, eight);
        this.setLayoutParams((ViewGroup.LayoutParams)editPanelLayoutParams);
        this.setOrientation(0);
        this.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams editTextLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        editTextLayoutParams.gravity = 16;
        editTextLayoutParams.weight = 1.0f;
        editTextLayoutParams.setMargins(0, 0, 0, 0);
        this.editText = new TextView(this.getContext());
        this.editText.setMinHeight(this.displayUtils.getDIP(36));
        this.editText.setGravity(16);
        this.editText.setTextSize(1, 14.0f);
        CompatUtils.setBackgroundDrawable((View)this.editText, this.makeTextViewBackground());
        this.editText.setHint((CharSequence)(" " + this.localizationService.getString("socialize_comment_hint")));
        this.editText.setLayoutParams((ViewGroup.LayoutParams)editTextLayoutParams);
        this.editText.setPadding(four, four, four, four);
        this.addView((View)this.editText);
    }

    protected Drawable makeTextViewBackground() {
        GradientDrawable base = this.makeGradient(this.colors.getColor("SOCIALIZE_BLUE"), this.colors.getColor("SOCIALIZE_BLUE"));
        base.setCornerRadius((float)(6 + this.displayUtils.getDIP(1)));
        GradientDrawable stroke = this.makeGradient(this.colors.getColor("TEXT_BG"), this.colors.getColor("TEXT_BG"));
        stroke.setCornerRadius(6.0f);
        LayerDrawable layers = new LayerDrawable(new Drawable[]{base, stroke});
        layers.setLayerInset(1, 2, 2, 2, 2);
        return layers;
    }

    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public TextView getEditText() {
        return this.editText;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

