/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.cache;

import com.socialize.cache.TTLCache;
import com.socialize.entity.Entity;
import com.socialize.ui.cache.CacheableEntity;

public class EntityCache
extends TTLCache<String, CacheableEntity> {
    private long timeToLive = 600000L;

    public EntityCache() {
    }

    public EntityCache(int initialCapacity) {
        super(initialCapacity);
    }

    public EntityCache(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public CacheableEntity putEntity(Entity entity) {
        CacheableEntity ce = new CacheableEntity(entity);
        this.put(entity.getKey(), ce, this.timeToLive);
        return ce;
    }

    public Entity getEntity(String key) {
        CacheableEntity cacheableEntity = (CacheableEntity)this.get(key);
        if (cacheableEntity != null) {
            return cacheableEntity.getEntity();
        }
        return null;
    }
}

