/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.auth;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import com.socialize.Socialize;
import com.socialize.android.ioc.BeanCreationListener;
import com.socialize.api.SocializeSession;
import com.socialize.api.event.EventSystem;
import com.socialize.api.event.SocializeEvent;
import com.socialize.config.SocializeConfig;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.auth.AuthDialogListener;
import com.socialize.ui.auth.AuthPanelView;
import com.socialize.ui.auth.IAuthDialogFactory;
import com.socialize.ui.dialog.AsyncDialogFactory;
import org.json.JSONObject;

public class AuthDialogFactory
extends AsyncDialogFactory<AuthPanelView, AuthDialogListener>
implements IAuthDialogFactory {
    private EventSystem eventSystem;
    private SocializeConfig config;

    @Override
    public void preload(Context context) {
        super.preload(context, new Object[0]);
    }

    @Override
    public void show(Context context, final AuthDialogListener listener, final boolean required) {
        this.showDialog(context, new BeanCreationListener<AuthPanelView>(){

            public void onError(String name, Exception e) {
            }

            public void onCreate(AuthPanelView bean) {
                bean.setAuthDialogListener(listener);
                bean.setAuthRequired(required);
            }
        }, new AuthDialogListener(){

            @Override
            public void onShow(Dialog dialog, AuthPanelView dialogView) {
                AuthDialogFactory.this.recordEvent("show");
                if (listener != null) {
                    listener.onShow(dialog, dialogView);
                }
            }

            @Override
            public void onCancel(Dialog dialog) {
                AuthDialogFactory.this.recordEvent("cancel");
                if (listener != null) {
                    listener.onCancel(dialog);
                }
            }

            @Override
            public void onSkipAuth(Activity context, Dialog dialog) {
                AuthDialogFactory.this.recordEvent("skip");
                if (listener != null) {
                    listener.onSkipAuth(context, dialog);
                }
            }

            @Override
            public void onError(Activity context, Dialog dialog, Exception error) {
                AuthDialogFactory.this.recordEvent("error");
                if (listener != null) {
                    listener.onError(context, dialog, error);
                }
            }

            @Override
            public void onAuthenticate(Activity context, Dialog dialog, SocialNetwork network) {
                AuthDialogFactory.this.recordEvent("auth", network.name());
                if (listener != null) {
                    listener.onAuthenticate(context, dialog, network);
                }
            }
        }, new Object[0]);
    }

    protected void recordEvent(String action) {
        this.recordEvent(action, null);
    }

    protected void recordEvent(String action, String network) {
        block5: {
            if (this.eventSystem != null && this.config != null && this.config.getBooleanProperty("socialize.events.auth.enabled", true)) {
                try {
                    SocializeSession session = Socialize.getSocialize().getSession();
                    if (session != null) {
                        SocializeEvent event = new SocializeEvent();
                        event.setBucket("AUTH_DIALOG");
                        JSONObject json = new JSONObject();
                        json.put("action", (Object)action);
                        if (network != null) {
                            json.put("network", (Object)network);
                        }
                        event.setData(json);
                        this.eventSystem.addEvent(session, event, null);
                    }
                }
                catch (Throwable e) {
                    if (this.logger == null) break block5;
                    this.logger.warn("Error recording share dialog event", e);
                }
            }
        }
    }

    public void setEventSystem(EventSystem eventSystem) {
        this.eventSystem = eventSystem;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

