/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.socialize.ui.animation.RotatingFadeViewAnimator;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;
import java.util.ArrayList;
import java.util.List;

public class ActionBarTicker
extends LinearLayout {
    public static final int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#222222");
    private List<View> views;
    private RotatingFadeViewAnimator rotator;
    private DisplayUtils displayUtils;
    private boolean initialized = false;
    private Integer backgroundColor;

    public ActionBarTicker(Context context) {
        super(context);
    }

    public ActionBarTicker(Context context, Integer backgroundColor) {
        super(context);
        this.backgroundColor = backgroundColor;
    }

    public void init(int width, float weight) {
        if (!this.initialized) {
            if (width > 0) {
                width = this.displayUtils.getDIP(width);
            }
            LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(width, this.displayUtils.getDIP(44));
            masterParams.gravity = 17;
            masterParams.weight = weight;
            this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
            ColorDrawable viewBg = new ColorDrawable(this.backgroundColor == null ? DEFAULT_BACKGROUND_COLOR : this.backgroundColor);
            CompatUtils.setBackgroundDrawable((View)this, (Drawable)viewBg);
            if (this.views != null) {
                this.rotator = new RotatingFadeViewAnimator(this.views.size());
                int index = 0;
                for (View view : this.views) {
                    this.rotator.addView(index, view);
                    this.addView(view);
                    ++index;
                }
                this.rotator.setFadeInTime(1500L);
                this.rotator.setFadeOutTime(1000L);
                this.rotator.setStickTime(5000L);
            }
            this.initialized = true;
        }
    }

    public void startTicker() {
        if (this.rotator != null) {
            this.rotator.start();
        }
    }

    public void skipToNext() {
        if (this.rotator != null) {
            this.rotator.skipToNext();
        }
        this.invalidate();
    }

    public void stopTicker() {
        if (this.rotator != null) {
            this.rotator.stop();
        }
    }

    public void resetTicker() {
        if (this.rotator != null) {
            this.rotator.reset();
        }
    }

    public void addTickerView(View view) {
        if (this.views == null) {
            this.views = new ArrayList<View>(10);
        }
        this.views.add(view);
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }
}

