/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.socialize.api.ShareMessageBuilder;
import com.socialize.api.action.ShareType;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.SocializeAction;
import com.socialize.networks.DefaultPostData;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.share.AbstractShareHandler;
import java.util.HashMap;

public class GooglePlusShareHandler
extends AbstractShareHandler {
    private ShareMessageBuilder shareMessageBuilder;
    static String PLUS_PACKAGE = "com.google.android.apps.plus";

    @Override
    public boolean isAvailableOnDevice(Context context) {
        try {
            context.getPackageManager().getPackageInfo(PLUS_PACKAGE, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    protected void handle(Activity context, SocializeAction action, String text, PropagationInfo info, SocialNetworkListener listener) throws Exception {
        boolean shareCancelled = false;
        Entity entity = action.getEntity();
        HashMap<String, Object> postValues = new HashMap<String, Object>();
        postValues.put("subject", this.shareMessageBuilder.buildShareSubject(entity));
        postValues.put("text", this.shareMessageBuilder.buildShareMessage(entity, info, text, false, true));
        DefaultPostData postData = new DefaultPostData();
        postData.setEntity(entity);
        postData.setPropagationInfo(info);
        postData.setPostValues(postValues);
        if (listener != null) {
            shareCancelled = listener.onBeforePost(context, null, postData);
        }
        if (!shareCancelled) {
            String body = String.valueOf(postValues.get("text"));
            String subject = String.valueOf(postValues.get("subject"));
            Intent shareIntent = new Intent().setAction("android.intent.action.SEND");
            shareIntent.addFlags(524288);
            shareIntent.putExtra("android.intent.extra.TEXT", body);
            shareIntent.putExtra("android.intent.extra.SUBJECT", subject);
            shareIntent.setType("text/plain");
            shareIntent.setPackage(PLUS_PACKAGE);
            context.startActivity(shareIntent);
        }
        if (listener != null) {
            listener.onAfterPost(context, null, null);
        }
    }

    @Override
    protected ShareType getShareType() {
        return ShareType.GOOGLE_PLUS;
    }

    public void setShareMessageBuilder(ShareMessageBuilder shareMessageBuilder) {
        this.shareMessageBuilder = shareMessageBuilder;
    }
}

