/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.Html;
import com.socialize.api.action.ShareType;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.SocializeAction;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.share.IntentShareHandler;
import com.socialize.share.SharePostDataFactory;

public class EmailShareHandler
extends IntentShareHandler {
    private SharePostDataFactory sharePostDataFactory;

    @Override
    protected void handle(Activity context, SocializeAction action, String text, PropagationInfo info, SocialNetworkListener listener) throws Exception {
        boolean shareCancelled = false;
        Entity entity = action.getEntity();
        PostData postData = this.sharePostDataFactory.create(entity, info, text, this.isHtml(), true);
        if (listener != null) {
            shareCancelled = listener.onBeforePost(context, null, postData);
        }
        if (!shareCancelled) {
            String title = String.valueOf(postData.getPostValues().get("title"));
            String body = String.valueOf(postData.getPostValues().get("text"));
            Intent msg = this.getIntent((Context)context);
            msg.putExtra("android.intent.extra.TITLE", title);
            if (this.isHtml()) {
                msg.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)body));
            } else {
                msg.putExtra("android.intent.extra.TEXT", body);
            }
            msg.putExtra("android.intent.extra.SUBJECT", String.valueOf(postData.getPostValues().get("subject")));
            this.startActivity(context, msg, title);
        }
        if (listener != null) {
            listener.onAfterPost(context, null, null);
        }
    }

    protected void startActivity(Activity context, Intent intent, String title) {
        Intent chooser = Intent.createChooser((Intent)intent, (CharSequence)title);
        chooser.setFlags(0x10000000);
        context.startActivity(chooser);
    }

    @Override
    protected String getMimeType() {
        return "message/rfc822";
    }

    protected boolean isHtml() {
        return true;
    }

    @Override
    protected ShareType getShareType() {
        return ShareType.EMAIL;
    }

    public void setSharePostDataFactory(SharePostDataFactory sharePostDataFactory) {
        this.sharePostDataFactory = sharePostDataFactory;
    }
}

