/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.share;

import android.app.Activity;
import android.location.Location;
import com.sharethis.loopy.sdk.Item;
import com.sharethis.loopy.sdk.ShareCallback;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.action.ShareType;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.PropagationInfoResponse;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.loopy.LoopyService;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.share.ShareHandler;

public abstract class AbstractShareHandler
implements ShareHandler {
    protected SocializeLogger logger;
    protected LoopyService loopyService;

    @Override
    public void handle(final Activity context, final SocializeAction action, Location location, final String text, final SocialNetworkListener listener) {
        block10: {
            ShareType shareType = this.getShareType();
            final SocialNetwork network = SocialNetwork.valueOf(shareType);
            PropagationInfoResponse propagationInfoResponse = action.getPropagationInfoResponse();
            if (propagationInfoResponse != null) {
                final PropagationInfo propagationInfo = propagationInfoResponse.getPropagationInfo(shareType);
                if (propagationInfo != null) {
                    try {
                        if (this.loopyService.isLoopyEnabled()) {
                            if (shareType.equals((Object)ShareType.OTHER)) {
                                this.loopyService.showShareDialog(context, "", text, action.getEntity(), propagationInfo, listener);
                            } else {
                                this.loopyService.getTrackableUrl(action.getEntity(), shareType, propagationInfo.getEntityUrl(), new ShareCallback(){

                                    public void onResult(Item item, Throwable error) {
                                        block3: {
                                            PropagationInfo infoInUse = AbstractShareHandler.this.loopyService.setShortlinks(propagationInfo, item, error);
                                            try {
                                                AbstractShareHandler.this.handle(context, action, text, infoInUse, listener);
                                            }
                                            catch (Exception e) {
                                                if (AbstractShareHandler.this.logger != null) {
                                                    AbstractShareHandler.this.logger.error("Error handling share", (Throwable)e);
                                                }
                                                if (listener == null) break block3;
                                                listener.onNetworkError(context, network, e);
                                            }
                                        }
                                    }
                                });
                            }
                            break block10;
                        }
                        this.handle(context, action, text, propagationInfo, listener);
                    }
                    catch (Exception e) {
                        if (this.logger != null) {
                            this.logger.error("Error handling share", (Throwable)e);
                        }
                        if (listener != null) {
                            listener.onNetworkError(context, network, e);
                        }
                        break block10;
                    }
                }
                this.logError(context, network, "No propagation info found for type [" + (Object)((Object)shareType) + "].  Share will not propagate", listener);
            } else {
                this.logError(context, network, "No propagation info found for type [" + (Object)((Object)shareType) + "].  Share will not propagate", listener);
            }
        }
    }

    protected void logError(Activity context, SocialNetwork network, String msg, SocialNetworkListener listener) {
        if (this.logger != null) {
            this.logger.warn(msg);
        } else {
            System.err.println(msg);
        }
        if (listener != null) {
            listener.onNetworkError(context, network, new SocializeException(msg));
        }
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setLoopyService(LoopyService loopyService) {
        this.loopyService = loopyService;
    }

    protected abstract void handle(Activity var1, SocializeAction var2, String var3, PropagationInfo var4, SocialNetworkListener var5) throws Exception;

    protected abstract ShareType getShareType();

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }
}

