/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import com.socialize.Socialize;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.user.UserSystem;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.notifications.NotificationAuthenticator;
import com.socialize.util.StringUtils;

public class SocializeNotificationAuthenticator
implements NotificationAuthenticator {
    private SocializeConfig config;
    private UserSystem userSystem;

    @Override
    public SocializeSession authenticate(Context context) throws SocializeException {
        String consumerSecret;
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        if (this.checkKeys(consumerKey, consumerSecret = this.config.getProperty("socialize.consumer.secret"))) {
            return this.userSystem.authenticateSynchronous(context, consumerKey, consumerSecret);
        }
        throw new SocializeException("Consumer key and/or secret not provided");
    }

    @Override
    public void authenticateAsync(Context context, SocializeAuthListener listener) throws SocializeException {
        String consumerSecret;
        String consumerKey = this.config.getProperty("socialize.consumer.key");
        if (this.checkKeys(consumerKey, consumerSecret = this.config.getProperty("socialize.consumer.secret"))) {
            this.userSystem.authenticate(context, consumerKey, consumerSecret, listener, Socialize.getSocialize());
        }
    }

    protected boolean checkKeys(String consumerKey, String consumerSecret) {
        return !StringUtils.isEmpty(consumerKey) && !StringUtils.isEmpty(consumerSecret);
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }
}

