/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.C2DMCallback;
import com.socialize.notifications.C2DMReceiverHandler;
import com.socialize.notifications.NotificationContainer;

public class SocializeC2DMReceiverHandler
implements C2DMReceiverHandler {
    private SocializeLogger logger = this.newSocializeLogger();
    private NotificationContainer container = this.newNotificationContainer();
    private C2DMCallback notificationCallback;

    protected void initBeans() {
        IOCContainer ioc = this.container.getContainer();
        if (ioc != null) {
            this.logger = (SocializeLogger)ioc.getBean("logger");
            this.notificationCallback = (C2DMCallback)ioc.getBean("notificationCallback");
        }
    }

    @Override
    public void onMessage(Context context, Intent intent) {
        try {
            if (this.notificationCallback != null) {
                Bundle extras;
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("SocializeC2DMReceiver received message");
                }
                if ((extras = intent.getExtras()) != null) {
                    this.notificationCallback.onMessage(context, extras);
                } else {
                    this.logWarn("No extras bundle found in notification intent.  Notification cannot be processed");
                }
            } else {
                this.logWarn("No notificationCallback found in GCM receiver.  Initialization may have failed.");
            }
        }
        catch (Exception e) {
            this.logError("Error processing GCM message", e);
        }
    }

    @Override
    public void onError(Context context, String errorId) {
        if (this.logger != null) {
            this.logger.error("GCM registration failed with error: " + errorId);
        }
        if (this.notificationCallback != null) {
            this.notificationCallback.onError(context, errorId);
        } else {
            this.logWarn("No notificationCallback found in GCM receiver.  Initialization may have failed.");
        }
    }

    @Override
    public void onRegistered(Context context, String registrationId) {
        try {
            if (this.notificationCallback != null) {
                this.notificationCallback.onRegister(context, registrationId);
            } else {
                this.logWarn("No notificationCallback found in GCM receiver.  Initialization may have failed.");
            }
        }
        catch (Exception e) {
            this.logError("GCM registration failed", e);
        }
    }

    @Override
    public void onUnregistered(Context context) {
        if (this.notificationCallback != null) {
            this.notificationCallback.onUnregister(context);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("SocializeC2DMReceiver successfully unregistered");
            }
        } else {
            this.logWarn("No notificationCallback found in GCM receiver.  Initialization may have failed.");
        }
    }

    @Override
    public void onCreate(Context context) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("SocializeC2DMReceiver creating..");
        }
        try {
            this.container.onCreate(context);
            this.initBeans();
        }
        catch (Exception e) {
            this.logError("Error initializing GCM receiver!", e);
        }
    }

    protected void logError(String msg, Exception e) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(msg, e);
        }
    }

    protected void logWarn(String msg) {
        if (this.logger != null) {
            this.logger.warn(msg);
        } else {
            System.err.println(msg);
        }
    }

    protected NotificationContainer newNotificationContainer() {
        return new NotificationContainer();
    }

    protected SocializeLogger newSocializeLogger() {
        return new SocializeLogger();
    }

    protected void setNotificationCallback(C2DMCallback notificationCallback) {
        this.notificationCallback = notificationCallback;
    }

    @Override
    public void onDestroy(Context context) {
        if (this.container != null) {
            this.container.onDestroy(context);
        }
    }

    NotificationContainer getNotificationContainer() {
        return this.container;
    }
}

