/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import com.socialize.error.SocializeException;
import com.socialize.notifications.BaseMessageTranslator;
import com.socialize.notifications.NotificationMessage;
import com.socialize.notifications.SimpleNotificationMessage;

public class SimpleNotificationMessageTranslator
extends BaseMessageTranslator<SimpleNotificationMessage> {
    @Override
    public SimpleNotificationMessage translate(Context context, NotificationMessage message) throws SocializeException {
        SimpleNotificationMessage msg = this.newSimpleNotificationMessage();
        StringBuilder titleBuilder = this.newStringBuilder();
        titleBuilder.append(message.getUser());
        switch (message.getActionType()) {
            case COMMENT: {
                titleBuilder.append(" commented on ");
                break;
            }
            case SHARE: {
                titleBuilder.append(" shared ");
                break;
            }
            case LIKE: {
                titleBuilder.append(" liked ");
                break;
            }
            case VIEW: {
                titleBuilder.append(" viewed ");
            }
        }
        titleBuilder.append(message.getEntity());
        msg.setTitle(titleBuilder.toString());
        msg.setText(message.getText());
        return msg;
    }

    protected SimpleNotificationMessage newSimpleNotificationMessage() {
        return new SimpleNotificationMessage();
    }

    protected StringBuilder newStringBuilder() {
        return new StringBuilder();
    }
}

