/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import android.content.SharedPreferences;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.User;
import com.socialize.log.SocializeLogger;
import com.socialize.util.StringUtils;

public class NotificationRegistrationState {
    private static final String PREFERENCES = "SocializeNotificationState";
    public static final long DEFAULT_SOCIALIZE_NOTIFICATION_TIMEOUT = 86400000L;
    public static final long DEFAULT_GCM_TIMEOUT = -1L;
    private String c2DMRegistrationId;
    private long registeredUserId;
    private long pendingC2DMRequestTime = 0L;
    private long pendingSocializeRequestTime = 0L;
    private long lastC2DMRegistrationTime = 0L;
    private long lastSocializeRegistrationTime = 0L;
    private String lastGCMSenderID = null;
    private String lastCustomGCMSenderId = null;
    private SocializeLogger logger;
    private SocializeConfig config;
    private boolean loaded = false;

    public boolean isRegisteredSocialize(Context context, User user) {
        this.load(context);
        long timeout = this.config.getLongProperty("socialize.notification.request.interval", 86400000L);
        long timeSinceLast = System.currentTimeMillis() - this.lastSocializeRegistrationTime;
        return this.registeredUserId == user.getId() && (timeSinceLast <= timeout || timeout < 0L);
    }

    public boolean isRegisteredC2DM(Context context) {
        this.load(context);
        if (StringUtils.isEmpty(this.lastGCMSenderID)) {
            return false;
        }
        if (!this.lastGCMSenderID.equals(this.config.getProperty("socialize.gcm.sender.id", ""))) {
            return false;
        }
        if (this.lastCustomGCMSenderId != null && !this.lastCustomGCMSenderId.equals(this.config.getProperty("socialize.custom.gcm.sender.id", ""))) {
            return false;
        }
        long timeout = this.config.getLongProperty("gcm.registration.interval", -1L);
        long timeSinceLast = System.currentTimeMillis() - this.lastC2DMRegistrationTime;
        return !StringUtils.isEmpty(this.c2DMRegistrationId) && (timeSinceLast <= timeout || timeout < 0L);
    }

    public void setRegisteredSocialize(User user) {
        this.registeredUserId = user.getId();
        this.pendingSocializeRequestTime = 0L;
        this.lastSocializeRegistrationTime = System.currentTimeMillis();
    }

    public String getC2DMRegistrationId() {
        return this.c2DMRegistrationId;
    }

    public void setC2DMRegistrationId(String c2dmRegistrationId) {
        this.c2DMRegistrationId = c2dmRegistrationId;
        this.lastC2DMRegistrationTime = System.currentTimeMillis();
        this.pendingC2DMRequestTime = 0L;
    }

    public boolean isSocializeRegistrationPending() {
        return System.currentTimeMillis() - this.pendingSocializeRequestTime < 30000L;
    }

    public boolean isC2dmPending() {
        return System.currentTimeMillis() - this.pendingC2DMRequestTime < 30000L;
    }

    public void setC2dmPendingRequestTime(long time) {
        this.pendingC2DMRequestTime = time;
    }

    public void setPendingSocializeRequestTime(long pendingSocializeRequestTime) {
        this.pendingSocializeRequestTime = pendingSocializeRequestTime;
    }

    public void reload(Context context) {
        this.loaded = false;
        this.load(context);
    }

    public void load(Context context) {
        if (!this.loaded) {
            SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
            this.c2DMRegistrationId = prefs.getString("c2DMRegistrationId", null);
            this.registeredUserId = prefs.getLong("registeredUserId", -1L);
            this.pendingC2DMRequestTime = prefs.getLong("pendingC2DMRequestTime", 0L);
            this.pendingSocializeRequestTime = prefs.getLong("pendingSocializeRequestTime", 0L);
            this.lastC2DMRegistrationTime = prefs.getLong("lastC2DMRegistrationTime", 0L);
            this.lastSocializeRegistrationTime = prefs.getLong("lastSocializeRegistrationTime", 0L);
            this.lastGCMSenderID = prefs.getString("lastGCMSenderID", "");
            this.lastCustomGCMSenderId = prefs.getString("lastCustomGCMSenderId", "");
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Loaded notification state with registration id [" + this.c2DMRegistrationId + "], user id [" + this.registeredUserId + "]");
            }
        }
        this.loaded = true;
    }

    public void save(Context context) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Saving notification state with registration id [" + this.c2DMRegistrationId + "], user id [" + this.registeredUserId + "]");
        }
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("c2DMRegistrationId", this.c2DMRegistrationId);
        editor.putLong("registeredUserId", this.registeredUserId);
        editor.putLong("pendingC2DMRequestTime", this.pendingC2DMRequestTime);
        editor.putLong("pendingSocializeRequestTime", this.pendingSocializeRequestTime);
        editor.putLong("lastC2DMRegistrationTime", this.lastC2DMRegistrationTime);
        editor.putLong("lastSocializeRegistrationTime", this.lastSocializeRegistrationTime);
        editor.putString("lastGCMSenderID", this.config.getProperty("socialize.gcm.sender.id", ""));
        editor.putString("lastCustomGCMSenderId", this.config.getProperty("socialize.custom.gcm.sender.id", ""));
        editor.commit();
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

