/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.RemoteViews;
import com.socialize.error.SocializeException;
import com.socialize.launcher.LaunchAction;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.MessageTranslator;
import com.socialize.notifications.NotificationMessage;
import com.socialize.notifications.NotificationMessageBuilder;
import com.socialize.notifications.NotificationMessageData;
import com.socialize.ui.SocializeLaunchActivity;
import com.socialize.util.AppUtils;
import com.socialize.util.DefaultAppUtils;
import com.socialize.util.StringUtils;

public abstract class BaseNotificationMessageBuilder<M extends NotificationMessageData>
implements NotificationMessageBuilder {
    private MessageTranslator<M> messageTranslator;
    private AppUtils appUtils;
    private SocializeLogger logger;

    @Override
    public Notification build(Context context, Bundle messageData, NotificationMessage message, int icon) throws SocializeException {
        Notification notification = this.newNotification(icon, message.getText(), System.currentTimeMillis());
        Intent notificationIntent = null;
        if (this.appUtils.isActivityAvailable(context, SocializeLaunchActivity.class)) {
            notificationIntent = this.newIntent(context, SocializeLaunchActivity.class);
            switch (message.getNotificationType()) {
                case NEW_COMMENTS: {
                    notificationIntent.putExtra("socialize.launch.action", LaunchAction.ACTION.name());
                    break;
                }
                case ENTITY_NOTIFICATION: {
                    notificationIntent.putExtra("socialize.launch.action", LaunchAction.ENTITY.name());
                    break;
                }
                case DEVELOPER_NOTIFICATION: {
                    notificationIntent.putExtra("socialize.launch.action", LaunchAction.HOME.name());
                    break;
                }
                case DEVELOPER_DIRECT_ENTITY: {
                    notificationIntent.putExtra("socialize.launch.action", LaunchAction.ENTITY.name());
                    break;
                }
                case DEVELOPER_DIRECT_URL: {
                    notificationIntent.putExtra("socialize.launch.action", LaunchAction.URL.name());
                }
            }
            notificationIntent.putExtra("socialize.launch.task", "notificationLaunchTask");
            notificationIntent.setFlags(0x50000000);
        } else {
            if (this.logger != null) {
                this.logger.warn("Could not locate activity [" + SocializeLaunchActivity.class + "].  Make sure you have added this to your AndroidManifest.xml");
            }
            notificationIntent = DefaultAppUtils.getMainAppIntent(context);
        }
        NotificationMessageData translated = (NotificationMessageData)this.messageTranslator.translate(context, messageData, message);
        notificationIntent.putExtras(messageData);
        notification.flags |= 0x10;
        PendingIntent contentIntent = this.getPendingIntent(context, message, notificationIntent);
        RemoteViews notificationView = this.getNotificationView(context, notification, message, translated);
        if (notificationView != null) {
            notification.contentIntent = contentIntent;
            notification.contentView = notificationView;
        } else {
            String title = translated.getTitle();
            String text = translated.getText();
            if (!StringUtils.isEmpty(title)) {
                if (text == null) {
                    text = "";
                }
                notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)text, contentIntent);
                notification.tickerText = title;
            } else {
                throw new SocializeException("Notification message has empty title");
            }
        }
        return notification;
    }

    protected PendingIntent getPendingIntent(Context context, NotificationMessage message, Intent notificationIntent) {
        return PendingIntent.getActivity((Context)context, (int)this.getNotificationId(message), (Intent)notificationIntent, (int)0x10000000);
    }

    public void setMessageTranslator(MessageTranslator<M> messageTranslator) {
        this.messageTranslator = messageTranslator;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected Notification newNotification(int icon, String text, long time) {
        return new Notification(icon, (CharSequence)text, time);
    }

    protected Intent newIntent(Context context, Class<?> cls) {
        return new Intent(context, cls);
    }

    protected int getNotificationId(NotificationMessage message) {
        Long entityId = message.getEntityId();
        if (entityId != null) {
            return entityId.intValue();
        }
        return 0;
    }

    public abstract RemoteViews getNotificationView(Context var1, Notification var2, NotificationMessage var3, M var4);
}

