/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.twitter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.socialize.SocializeActionProxy;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.entity.Entity;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.twitter.PhotoTweet;
import com.socialize.networks.twitter.Tweet;
import com.socialize.networks.twitter.TwitterUtilsProxy;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;

public class TwitterUtils {
    static TwitterUtilsProxy proxy = (TwitterUtilsProxy)Proxy.newProxyInstance(TwitterUtilsProxy.class.getClassLoader(), new Class[]{TwitterUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("twitterUtils"));

    public static void link(Activity context, SocializeAuthListener listener) {
        proxy.link(context, listener);
    }

    public static void link(Activity context, String token, String secret, SocializeAuthListener listener) {
        proxy.link(context, token, secret, listener);
    }

    public static void unlink(Context context) {
        proxy.unlink(context);
    }

    public static boolean isLinked(Context context) {
        return proxy.isLinked(context);
    }

    public static boolean isAvailable(Context context) {
        return proxy.isAvailable(context);
    }

    public static void setCredentials(Context context, String consumerKey, String consumerSecret) {
        proxy.setCredentials(context, consumerKey, consumerSecret);
    }

    public static String getAccessToken(Context context) {
        return proxy.getAccessToken(context);
    }

    public static String getTokenSecret(Context context) {
        return proxy.getTokenSecret(context);
    }

    public static void tweetEntity(final Activity context, final Entity entity, final String text, final SocialNetworkShareListener listener) {
        if (proxy.isLinked((Context)context)) {
            proxy.tweetEntity(context, entity, text, listener);
        } else {
            proxy.link(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.tweetEntity(context, entity, text, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }
            });
        }
    }

    public static void post(final Activity context, final String resource, final Map<String, Object> postData, final SocialNetworkPostListener listener) {
        if (proxy.isLinked((Context)context)) {
            proxy.post(context, resource, postData, listener);
        } else {
            proxy.link(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.post(context, resource, postData, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }
            });
        }
    }

    public static void get(final Activity context, final String resource, final Map<String, Object> params, final SocialNetworkPostListener listener) {
        if (proxy.isLinked((Context)context)) {
            proxy.get(context, resource, params, listener);
        } else {
            proxy.link(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.get(context, resource, params, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }
            });
        }
    }

    public static void tweet(final Activity context, final Tweet tweet, final SocialNetworkListener listener) {
        if (proxy.isLinked((Context)context)) {
            proxy.tweet(context, tweet, listener);
        } else {
            proxy.link(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.tweet(context, tweet, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }
            });
        }
    }

    public static void tweetPhoto(final Activity context, final PhotoTweet photo, final SocialNetworkPostListener listener) {
        if (proxy.isLinked((Context)context)) {
            proxy.tweetPhoto(context, photo, listener);
        } else {
            proxy.link(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.tweetPhoto(context, photo, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                    }
                }
            });
        }
    }

    public static byte[] getImageForPost(Activity context, Uri imagePath) throws IOException {
        return proxy.getImageForPost(context, imagePath);
    }

    public static byte[] getImageForPost(Activity context, Bitmap image, Bitmap.CompressFormat format) throws IOException {
        return proxy.getImageForPost(context, image, format);
    }
}

