/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Base64;
import com.socialize.SocializeActionProxy;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.entity.Entity;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.SocializeDeAuthListener;
import com.socialize.networks.facebook.FacebookUtilsProxy;
import com.socialize.networks.facebook.OnPermissionResult;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class FacebookUtils {
    static FacebookUtilsProxy proxy = (FacebookUtilsProxy)Proxy.newProxyInstance(FacebookUtilsProxy.class.getClassLoader(), new Class[]{FacebookUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("facebookUtils"));

    public static void linkForRead(Activity context, SocializeAuthListener listener, String ... permissions) {
        proxy.linkForRead(context, listener, permissions);
    }

    public static void linkForRead(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener, String ... permissions) {
        proxy.linkForRead(context, token, verifyPermissions, listener, permissions);
    }

    public static void linkForWrite(Activity context, SocializeAuthListener listener, String ... permissions) {
        proxy.linkForWrite(context, listener, permissions);
    }

    public static void linkForWrite(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener, String ... permissions) {
        proxy.linkForWrite(context, token, verifyPermissions, listener, permissions);
    }

    @Deprecated
    public static void link(Activity context, SocializeAuthListener listener) {
        proxy.link(context, listener);
    }

    @Deprecated
    public static void link(Activity context, SocializeAuthListener listener, String ... permissions) {
        proxy.link(context, listener, permissions);
    }

    @Deprecated
    public static void link(Activity context, String token, boolean verifyPermissions, SocializeAuthListener listener) {
        proxy.link(context, token, verifyPermissions, listener);
    }

    public static void unlink(Context context) {
        proxy.unlink(context, null);
    }

    public static void unlink(Context context, SocializeDeAuthListener listener) {
        proxy.unlink(context, listener);
    }

    @Deprecated
    public static boolean isLinked(Context context) {
        return proxy.isLinked(context);
    }

    public static boolean isLinkedForRead(Context context, String ... permissions) {
        return proxy.isLinkedForRead(context, permissions);
    }

    public static boolean isLinkedForWrite(Context context, String ... permissions) {
        return proxy.isLinkedForWrite(context, permissions);
    }

    public static boolean isAvailable(Context context) {
        return proxy.isAvailable(context);
    }

    public static void setAppId(Context context, String appId) {
        proxy.setAppId(context, appId);
    }

    public static String getAccessToken(Context context) {
        return proxy.getAccessToken(context);
    }

    public static void postEntity(final Activity context, final Entity entity, final String text, final SocialNetworkShareListener listener) {
        if (proxy.isLinkedForWrite((Context)context, new String[0])) {
            proxy.postEntity(context, entity, text, listener);
        } else {
            proxy.linkForWrite(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.postEntity(context, entity, text, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }
            }, new String[0]);
        }
    }

    public static void post(final Activity context, final String graphPath, final Map<String, Object> params, final SocialNetworkPostListener listener) {
        if (proxy.isLinkedForWrite((Context)context, new String[0])) {
            proxy.post(context, graphPath, params, listener);
        } else {
            proxy.linkForWrite(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.post(context, graphPath, params, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }
            }, new String[0]);
        }
    }

    public static void get(final Activity context, final String graphPath, final Map<String, Object> params, final SocialNetworkPostListener listener) {
        if (proxy.isLinkedForRead((Context)context, new String[0])) {
            proxy.get(context, graphPath, params, listener);
        } else {
            proxy.linkForRead(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.get(context, graphPath, params, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }
            }, new String[0]);
        }
    }

    public static void delete(final Activity context, final String graphPath, final Map<String, Object> params, final SocialNetworkPostListener listener) {
        if (proxy.isLinkedForWrite((Context)context, new String[0])) {
            proxy.delete(context, graphPath, params, listener);
        } else {
            proxy.linkForWrite(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }

                @Override
                public void onCancel() {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    proxy.delete(context, graphPath, params, listener);
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    if (listener != null) {
                        listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                    }
                }
            }, new String[0]);
        }
    }

    public static byte[] getImageForPost(Activity context, Uri imagePath) throws IOException {
        return proxy.getImageForPost(context, imagePath);
    }

    public static byte[] getImageForPost(Activity context, Bitmap image, Bitmap.CompressFormat format) throws IOException {
        return proxy.getImageForPost(context, image, format);
    }

    @Deprecated
    public static void extendAccessToken(Activity context, SocializeAuthListener listener) {
        proxy.extendAccessToken(context, listener);
    }

    public static void onResume(Activity context, SocializeAuthListener listener) {
        proxy.onResume(context, listener);
    }

    public static void getCurrentPermissions(Activity context, String token, OnPermissionResult callback) {
        proxy.getCurrentPermissions(context, token, callback);
    }

    public static String[] getHashKeys(Activity context) throws NoSuchAlgorithmException {
        PackageInfo packageInfo = null;
        String[] keys = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                keys = new String[packageInfo.signatures.length];
                for (int i = 0; i < packageInfo.signatures.length; ++i) {
                    String hash;
                    Signature signature = packageInfo.signatures[i];
                    MessageDigest md = MessageDigest.getInstance("SHA1");
                    md.update(signature.toByteArray());
                    keys[i] = hash = new String(Base64.encode((byte[])md.digest(), (int)0));
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return keys;
    }
}

