/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks;

import android.app.Dialog;
import android.content.Context;
import com.socialize.auth.AuthProviderType;
import com.socialize.concurrent.ManagedAsyncTask;
import com.socialize.networks.SocialNetworkSignOutListener;
import com.socialize.networks.facebook.FacebookUtils;
import com.socialize.networks.twitter.TwitterUtils;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.util.IAsyncTask;
import java.lang.ref.WeakReference;

public class SocialNetworkSignOutTask
extends ManagedAsyncTask<Void, Void, Void>
implements IAsyncTask<Void, Void, Void> {
    private WeakReference<Context> context;
    private ProgressDialogFactory dialogFactory;
    private SocialNetworkSignOutListener signOutListener;
    private Dialog dialog;
    private AuthProviderType type;

    public SocialNetworkSignOutTask(Context context) {
        this.context = new WeakReference<Context>(context);
    }

    protected void onPreExecute() {
        this.dialog = this.dialogFactory.show((Context)this.context.get(), "socialize_auth_dialog_sign_out", "socialize_please_wait");
    }

    public void doExecute(Void ... params) {
        this.execute(params);
    }

    protected Void doInBackground(Void ... args) {
        switch (this.type) {
            case FACEBOOK: {
                FacebookUtils.unlink((Context)this.context.get());
                break;
            }
            case TWITTER: {
                TwitterUtils.unlink((Context)this.context.get());
            }
        }
        return null;
    }

    @Override
    protected void onPostExecuteManaged(Void result) {
        this.dialog.dismiss();
        if (this.signOutListener != null) {
            this.signOutListener.onSignOut();
        }
    }

    public void setDialogFactory(ProgressDialogFactory dialogFactory) {
        this.dialogFactory = dialogFactory;
    }

    public void setSignOutListener(SocialNetworkSignOutListener facebookSignOutListener) {
        this.signOutListener = facebookSignOutListener;
    }

    public void setType(AuthProviderType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = AuthProviderType.valueOf(type.toUpperCase().trim());
    }
}

