/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.net;

import com.socialize.apache.http.entity.mime.MultipartEntity;
import com.socialize.concurrent.ManagedAsyncTask;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.net.AsyncHttpRequest;
import com.socialize.net.AsyncHttpResponse;
import com.socialize.net.HttpClientFactory;
import com.socialize.net.HttpRequestListener;
import com.socialize.util.HttpUtils;
import com.socialize.util.IOUtils;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class AsyncHttpRequestProcessor
extends ManagedAsyncTask<AsyncHttpRequest, Void, AsyncHttpResponse> {
    private HttpClientFactory clientFactory;
    private HttpUtils httpUtils;
    private IOUtils ioUtils;
    private SocializeLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncHttpResponse doInBackground(AsyncHttpRequest ... params) {
        AsyncHttpResponse response;
        block12: {
            AsyncHttpRequest request = params[0];
            response = new AsyncHttpResponse();
            response.setRequest(request);
            try {
                HttpUriRequest httpRequest = request.getRequest();
                if (!this.clientFactory.isDestroyed()) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        HttpPost post;
                        HttpEntity entity;
                        Header[] allHeaders;
                        this.logger.debug("Request: " + httpRequest.getMethod() + " " + httpRequest.getRequestLine().getUri());
                        StringBuilder builder = new StringBuilder();
                        for (Header header : allHeaders = httpRequest.getAllHeaders()) {
                            builder.append(header.getName());
                            builder.append(":");
                            builder.append(header.getValue());
                            builder.append("\n");
                        }
                        this.logger.debug("REQUEST \nurl:[" + httpRequest.getURI().toString() + "] \nheaders:\n" + builder.toString());
                        if (httpRequest instanceof HttpPost && !((entity = (post = (HttpPost)httpRequest).getEntity()) instanceof MultipartEntity)) {
                            String requestData = this.ioUtils.readSafe(entity.getContent());
                            this.logger.debug("REQUEST \ndata:[" + requestData + "]");
                        }
                    }
                    HttpClient client = this.clientFactory.getClient();
                    HttpResponse httpResponse = client.execute(httpRequest);
                    response.setResponse(httpResponse);
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("RESPONSE CODE: " + httpResponse.getStatusLine().getStatusCode());
                    }
                    HttpEntity entity = null;
                    try {
                        entity = httpResponse.getEntity();
                        if (this.httpUtils.isHttpError(httpResponse)) {
                            String msg = this.ioUtils.readSafe(entity.getContent());
                            throw new SocializeApiError(this.httpUtils, httpResponse.getStatusLine().getStatusCode(), msg);
                        }
                        String responseData = this.ioUtils.readSafe(entity.getContent());
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("RESPONSE: " + responseData);
                        }
                        response.setResponseData(responseData);
                        break block12;
                    }
                    finally {
                        this.closeEntity(entity);
                    }
                }
                throw new SocializeException("Cannot execute http request.  HttpClient factory was destroyed.");
            }
            catch (Exception e) {
                response.setError(e);
            }
        }
        return response;
    }

    @Override
    protected void onPostExecuteManaged(AsyncHttpResponse result) {
        AsyncHttpRequest request = result.getRequest();
        HttpRequestListener listener = request.getListener();
        if (listener != null) {
            HttpResponse response = result.getResponse();
            String responseData = result.getResponseData();
            int error = -1;
            if (response != null) {
                error = response.getStatusLine().getStatusCode();
            }
            if (result.getError() != null) {
                listener.onError(result.getError(), response, error, responseData);
            } else {
                listener.onSuccess(response, responseData);
            }
        }
        if (result.getError() != null && this.logger != null) {
            this.logger.error("Error during http request", (Throwable)result.getError());
        }
    }

    private final void closeEntity(HttpEntity entity) {
        block3: {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (IOException e) {
                    if (this.logger == null) break block3;
                    this.logger.warn("Failed to fully consume http response content", (Throwable)e);
                }
            }
        }
    }

    public void setClientFactory(HttpClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public void setIoUtils(IOUtils ioUtils) {
        this.ioUtils = ioUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

