/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.location;

import android.app.Activity;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.config.SocializeConfig;
import com.socialize.location.SocializeLocationListener;
import com.socialize.location.SocializeLocationManager;
import com.socialize.location.SocializeLocationProvider;
import com.socialize.log.SocializeLogger;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;

public class DefaultLocationProvider
implements SocializeLocationProvider {
    private AppUtils appUtils;
    private Location location;
    private SocializeLocationManager locationManager;
    private IBeanFactory<SocializeLocationListener> locationListenerFactory;
    private SocializeLocationListener listener = null;
    private SocializeLogger logger;
    private SocializeConfig config;

    public void init(Context context) {
        if (this.locationListenerFactory != null) {
            this.listener = (SocializeLocationListener)this.locationListenerFactory.getBean();
        }
        this.getLocation(context);
    }

    public void destroy() {
        this.stop();
    }

    @Override
    public void pause(Context context) {
        this.stop();
    }

    @Override
    public void resume(Context context) {
        this.getLocation(context);
    }

    public void stop() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("LocationProvider ceasing location updates");
        }
        if (this.locationManager != null && this.listener != null) {
            this.locationManager.removeUpdates(this.listener);
        }
    }

    @Override
    public Location getLastKnownLocation() {
        return this.location;
    }

    @Override
    public Location getLocation(Context context) {
        if (this.config != null && this.config.getBooleanProperty("socialize.location.enabled", true)) {
            if (this.location == null) {
                if (this.appUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION")) {
                    this.requestLocation(context, 1);
                } else if (this.appUtils.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
                    this.requestLocation(context, 2);
                }
            } else if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("LocationProvider got location");
            }
        }
        return this.location;
    }

    protected void requestLocation(Context context, int accuracy) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("LocationProvider Requesting location...");
        }
        Criteria criteria = new Criteria();
        criteria.setAccuracy(accuracy);
        String provider = this.locationManager.getBestProvider(criteria, true);
        if (!StringUtils.isEmpty(provider)) {
            Location mostRecentLocation = this.locationManager.getLastKnownLocation(provider);
            if (mostRecentLocation != null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Got location from last known provider");
                }
                this.location = mostRecentLocation;
                this.locationManager.removeUpdates(this.listener);
            } else if (this.locationManager.isProviderEnabled(provider)) {
                if (this.listener != null) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("No last known location, requesting from device...");
                    }
                    if (context instanceof Activity) {
                        this.locationManager.requestLocationUpdates((Activity)context, provider, 1L, 0.0f, this.listener);
                    } else if (this.logger != null && this.logger.isWarnEnabled()) {
                        this.logger.warn("Cannot request location using a non-activity context");
                    }
                } else if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn("No listener specified for location callback");
                }
            } else if (this.logger != null && this.logger.isWarnEnabled()) {
                this.logger.warn("Location provider [" + provider + "] is not enabled");
            }
        } else if (this.logger != null && this.logger.isWarnEnabled()) {
            this.logger.warn("No provider found to determine location based on accuracy [" + accuracy + "].  Check that location is enabled in the device and location permissions set on the app");
        }
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setLocationManager(SocializeLocationManager locationManager) {
        this.locationManager = locationManager;
    }

    protected SocializeLocationManager getLocationManager() {
        return this.locationManager;
    }

    protected void setLocation(Location location) {
        this.location = location;
    }

    public void setLocationListenerFactory(IBeanFactory<SocializeLocationListener> listenerFactory) {
        this.locationListenerFactory = listenerFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

