/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher.task;

import android.content.Context;
import android.os.Bundle;
import com.socialize.api.SocializeSession;
import com.socialize.api.event.EventListener;
import com.socialize.api.event.EventSystem;
import com.socialize.api.event.SocializeEvent;
import com.socialize.error.SocializeException;
import com.socialize.launcher.LaunchTask;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationAuthenticator;
import org.json.JSONObject;

public class NotificationOpenEventTask
implements LaunchTask {
    private EventSystem eventSystem;
    private SocializeLogger logger;
    private NotificationAuthenticator notificationAuthenticator;

    @Override
    public void execute(Context context, Bundle extras) throws SocializeException {
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Recording notification open event...");
            }
            final SocializeEvent event = new SocializeEvent();
            event.setBucket("NOTIFICATION_OPEN");
            String json = extras.getString("message");
            JSONObject obj = new JSONObject(json);
            event.setData(obj);
            this.notificationAuthenticator.authenticateAsync(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    NotificationOpenEventTask.this.logError(error);
                }

                @Override
                public void onCancel() {
                }

                @Override
                public void onAuthSuccess(SocializeSession session) {
                    NotificationOpenEventTask.this.eventSystem.addEvent(session, event, new EventListener(){

                        @Override
                        public void onError(SocializeException error) {
                            NotificationOpenEventTask.this.logError(error);
                        }

                        @Override
                        public void onPost() {
                            if (NotificationOpenEventTask.this.logger != null && NotificationOpenEventTask.this.logger.isDebugEnabled()) {
                                NotificationOpenEventTask.this.logger.debug("Notification open event recorded.");
                            }
                        }
                    });
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    NotificationOpenEventTask.this.logError(error);
                }
            });
        }
        catch (Exception e) {
            throw SocializeException.wrap(e);
        }
    }

    protected void logError(Exception e) {
        if (this.logger != null) {
            this.logger.error("Error recording notification open event", (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    public void setEventSystem(EventSystem eventSystem) {
        this.eventSystem = eventSystem;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setNotificationAuthenticator(NotificationAuthenticator notificationAuthenticator) {
        this.notificationAuthenticator = notificationAuthenticator;
    }
}

