/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.entity.EntitySystem;
import com.socialize.entity.Entity;
import com.socialize.launcher.BaseLauncher;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationAuthenticator;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.util.EntityLoaderUtils;

public class EntityLauncher
extends BaseLauncher {
    private EntityLoaderUtils entityLoaderUtils;
    private SocializeLogger logger;
    private EntitySystem entitySystem;
    private NotificationAuthenticator notificationAuthenticator;

    @Override
    public boolean launch(Activity context, Bundle data) {
        if (this.entityLoaderUtils != null) {
            SocializeEntityLoader entityLoader = this.entityLoaderUtils.initEntityLoader();
            if (entityLoader != null) {
                Object idObj = data.get("socialize.entity.id");
                if (idObj != null) {
                    long id = Long.parseLong(idObj.toString());
                    try {
                        SocializeSession session = this.notificationAuthenticator.authenticate((Context)context);
                        Entity entity = this.entitySystem.getEntitySynchronous(session, id);
                        return this.loadEntity(context, entityLoader, entity);
                    }
                    catch (Exception e) {
                        this.handleError("Failed to load entity", e);
                    }
                } else {
                    this.handleWarn("No entity id found.  Entity based notification cannot be handled");
                }
            } else {
                this.handleWarn("No entity loader found.  Entity based notification cannot be handled");
            }
        }
        return false;
    }

    protected boolean loadEntity(Activity context, SocializeEntityLoader entityLoader, Entity entity) {
        if (entity != null) {
            if (entityLoader.canLoad((Context)context, entity)) {
                if (this.logger != null && this.logger.isInfoEnabled()) {
                    this.logger.info("Calling entity loader for entity with key [" + entity.getKey() + "]");
                }
                entityLoader.loadEntity(context, entity);
                return true;
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Entity loaded indicates that entity with key [" + entity.getKey() + "] cannot be loaded");
            }
        } else {
            this.handleWarn("No entity object found under key [socialize.entity] in EntityLaucher");
        }
        return false;
    }

    protected void handleWarn(String msg) {
        if (this.logger != null) {
            this.logger.warn(msg);
        } else {
            System.err.println(msg);
        }
    }

    protected void handleError(String msg, Exception e) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    public void setEntityLoaderUtils(EntityLoaderUtils entityLoaderUtils) {
        this.entityLoaderUtils = entityLoaderUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setEntitySystem(EntitySystem entitySystem) {
        this.entitySystem = entitySystem;
    }

    public void setNotificationAuthenticator(NotificationAuthenticator notificationAuthenticator) {
        this.notificationAuthenticator = notificationAuthenticator;
    }
}

