/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.error;

import com.socialize.error.SocializeException;
import com.socialize.util.HttpUtils;
import com.socialize.util.StringUtils;

public class SocializeApiError
extends SocializeException {
    private static final long serialVersionUID = 6929605095508741864L;
    private int resultCode;
    private HttpUtils utils;
    private String message;

    public SocializeApiError(HttpUtils utils, int resultCode, String message) {
        this.resultCode = resultCode;
        this.utils = utils;
        this.message = message;
    }

    public SocializeApiError(int resultCode, String message) {
        this.resultCode = resultCode;
        this.message = message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getDescription() {
        return this.message;
    }

    @Override
    public String getMessage() {
        if (this.utils != null) {
            String codeMessage = this.utils.getMessageFor(this.resultCode);
            String msg = codeMessage + " (" + this.resultCode + ")";
            if (!StringUtils.isEmpty(this.message)) {
                msg = msg + ", " + this.message;
            }
            return msg;
        }
        if (StringUtils.isEmpty(this.message)) {
            return "(" + this.resultCode + ")";
        }
        return "(" + this.resultCode + "), " + this.message;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

