/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.auth.AuthProviderType;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.UserAuthData;
import com.socialize.log.SocializeLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class UserAuthDataFactory
extends SocializeObjectFactory<UserAuthData> {
    private static final String AUTH_ID = "auth_id";
    private static final String AUTH_TYPE = "auth_type";
    private SocializeLogger logger;

    @Override
    public Object instantiateObject(JSONObject object) {
        return new UserAuthData();
    }

    @Override
    protected void postFromJSON(JSONObject from, UserAuthData to) throws JSONException {
        if (from.has(AUTH_ID) && !from.isNull(AUTH_ID)) {
            to.setId(from.getLong(AUTH_ID));
        }
        if (from.has(AUTH_TYPE) && !from.isNull(AUTH_TYPE)) {
            String string = from.getString(AUTH_TYPE).trim().toUpperCase();
            try {
                AuthProviderType type = AuthProviderType.valueOf(string);
                to.setAuthProviderType(type);
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.error("Failed to parse auth type [" + string + "]", (Throwable)e);
                }
                SocializeLogger.e(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void postToJSON(UserAuthData from, JSONObject to) throws JSONException {
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

